/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.deployment;

import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStore;

import org.slf4j.Logger;

public class DeploymentExceptionHandler {

  private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(DeploymentExceptionHandler.class);

  private PolicyStore policyStore;

  public DeploymentExceptionHandler(PolicyStore policyStore) {
    this.policyStore = policyStore;
  }

  public void handle(PolicyDefinition policyDefinition, ApiImplementation implementation,
                     Exception exception) {
    logDeploymentError(policyDefinition.getName(), implementation.getArtifactName(), exception);
    policyStore.storeDeploymentFailure(policyDefinition, implementation.getApiKey(), exception);
  }

  private void logDeploymentError(String policyName, String appName, Exception e) {
    LOGGER.error("Error deploying policy " + policyName + " to application " + appName, e);
  }

}
