/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.lifecyle;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;

import java.util.List;

public interface PolicySetDeploymentListener {

  /**
   * Notifies that the deployment of a {@link PolicySet} has been completed
   *
   * @param apiKey key of the API
   * @param policySet set of policies that were deployed
   * @param deploymentStatuses statuses of policies that were deployed
   */
  default void onPolicySetDeploymentCompleted(ApiKey apiKey, PolicySet policySet,
                                              List<PolicyDeploymentStatus> deploymentStatuses) {}

  /**
   * Notifies that policies of an API have been removed
   *
   * @param apiKey key of the API
   */
  default void onPoliciesRemoved(ApiKey apiKey) {}
}
