/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.service;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;

import java.util.List;
import java.util.Optional;

/**
 * Keeps track of the deployment status of the policies
 */
public interface PolicyDeploymentListener {

  /**
   * Informs that a policy was removed
   * 
   * @param apiKey the api owner of the policy
   * @param status of the policy that was removed
   */
  void policyRemoved(ApiKey apiKey, PolicyDeploymentStatus status);

  /**
   * Informs that the a policy was deployed.
   *
   * @param apiKey the api owner of the policy
   * @param status of the policy that was removed
   */
  void policyDeployed(ApiKey apiKey, PolicyDeploymentStatus status);

}
