/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.service;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.policies.Policy;

/**
 * Provides functionality to handle policies in a broader way than the policy engine.
 */
public interface PolicyDeploymentService {

  /**
   * Deploys a policy to the API implementations specified in the definition
   *
   * @param policy policy definition to handle
   */
  void newPolicy(Policy policy);

  /**
   * Deploys a policy to a specific API implementation, if it is included in the policy definition
   *
   * @param policy policy definition to handle
   */
  void newPolicyForApi(Policy policy, ApiKey apiKey);

  /**
   * First undeploys the policiy, and then deploys it again
   *
   * @param policy updated definition
   */
  void updatePolicy(Policy policy);

  /**
   * Removes the specified policy from the API implementation specified in the definition
   *
   * @param policyName name of the policy to remove
   */
  void removePolicy(String policyName);

  /**
   * Removes the specified policy from the API implementation specified in the definition
   *
   * @param policy policy definition to remove
   */
  void removePolicy(Policy policy);

}
