/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies;

import static com.google.common.collect.ImmutableMap.of;
import static com.google.common.collect.Lists.newArrayList;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.API_KEY;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.API_KEY_2;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_ID;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_ID_2;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_TEMPLATE_KEY;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_TEMPLATE_KEY_2;
import static java.util.Collections.emptyMap;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotEquals;

import org.mule.tck.junit4.AbstractMuleTestCase;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.HttpResourcePointcut;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;

import org.junit.Test;

public class PolicyDefinitionTestCase extends AbstractMuleTestCase {

  @Test
  public void definitionsAreEquals() {
    HttpResourcePointcut resourcePointcut = new HttpResourcePointcut(".*", "GET");
    HttpResourcePointcut resourcePointcut2 = new HttpResourcePointcut(".*", "GET");
    ApiKey apiKey = new ApiKey(1L);
    ApiKey apiKey2 = new ApiKey(1L);

    PolicyConfiguration policyConfiguration = new PolicyConfiguration(
                                                                      of("string", "value", "int", 60000, "object",
                                                                         of("prop", "value")));

    PolicyDefinition policyDefinition =
        new PolicyDefinition(POLICY_ID, POLICY_TEMPLATE_KEY, apiKey, newArrayList(resourcePointcut), 1, policyConfiguration);
    PolicyDefinition policyDefinition2 =
        new PolicyDefinition(POLICY_ID, POLICY_TEMPLATE_KEY, apiKey2, newArrayList(resourcePointcut2), 1, policyConfiguration);

    assertEquals(policyDefinition, policyDefinition2);
  }

  @Test
  public void differentIdNotEquals() {
    PolicyDefinition policyDefinition =
        new PolicyDefinition(POLICY_ID, POLICY_TEMPLATE_KEY, API_KEY, newArrayList(), 1, emptyMap());
    PolicyDefinition policyDefinition2 =
        new PolicyDefinition(POLICY_ID_2, POLICY_TEMPLATE_KEY, API_KEY, newArrayList(), 1, emptyMap());

    assertNotEquals(policyDefinition, policyDefinition2);
  }

  @Test
  public void differentTemplateNotEquals() {
    PolicyDefinition policyDefinition =
        new PolicyDefinition(POLICY_ID, POLICY_TEMPLATE_KEY, API_KEY, newArrayList(), 1, emptyMap());
    PolicyDefinition policyDefinition2 =
        new PolicyDefinition(POLICY_ID, POLICY_TEMPLATE_KEY_2, API_KEY, newArrayList(), 1, emptyMap());

    assertNotEquals(policyDefinition, policyDefinition2);
  }

  @Test
  public void differentApiNotEquals() {
    PolicyDefinition policyDefinition =
        new PolicyDefinition(POLICY_ID, POLICY_TEMPLATE_KEY, API_KEY, newArrayList(), 1, emptyMap());
    PolicyDefinition policyDefinition2 =
        new PolicyDefinition(POLICY_ID, POLICY_TEMPLATE_KEY, API_KEY_2, newArrayList(), 1, emptyMap());

    assertNotEquals(policyDefinition, policyDefinition2);
  }

  @Test
  public void differentResourcePointcutNotEquals() {
    HttpResourcePointcut resourcePointcut = new HttpResourcePointcut(".*", "GET");
    HttpResourcePointcut resourcePointcut2 = new HttpResourcePointcut(".*", "POST");
    PolicyDefinition policyDefinition =
        new PolicyDefinition(POLICY_ID, POLICY_TEMPLATE_KEY, API_KEY, newArrayList(resourcePointcut), 1, emptyMap());
    PolicyDefinition policyDefinition2 =
        new PolicyDefinition(POLICY_ID, POLICY_TEMPLATE_KEY, API_KEY, newArrayList(resourcePointcut2), 1, emptyMap());

    assertNotEquals(policyDefinition, policyDefinition2);
  }

  @Test
  public void differentOrderNotEquals() {
    PolicyDefinition policyDefinition =
        new PolicyDefinition(POLICY_ID, POLICY_TEMPLATE_KEY, API_KEY, newArrayList(), 1, emptyMap());
    PolicyDefinition policyDefinition2 =
        new PolicyDefinition(POLICY_ID, POLICY_TEMPLATE_KEY, API_KEY, newArrayList(), 2, emptyMap());

    assertNotEquals(policyDefinition, policyDefinition2);
  }

  @Test
  public void differentConfigDataNotEquals() {
    PolicyConfiguration policyConfiguration = new PolicyConfiguration(of("string", "value2"));
    PolicyConfiguration policyConfiguration2 = new PolicyConfiguration(of("string", "value"));

    PolicyDefinition policyDefinition =
        new PolicyDefinition(POLICY_ID, POLICY_TEMPLATE_KEY, API_KEY, newArrayList(), 1, policyConfiguration);
    PolicyDefinition policyDefinition2 =
        new PolicyDefinition(POLICY_ID, POLICY_TEMPLATE_KEY, API_KEY, newArrayList(), 1, policyConfiguration2);

    assertNotEquals(policyDefinition, policyDefinition2);
  }

}
