/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.offline;

import static org.hamcrest.Matchers.containsString;

import com.mulesoft.mule.runtime.gw.policies.serialization.OfflinePolicyDeserializationException;

import java.io.File;
import java.net.URISyntaxException;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class OfflinePolicyDefinitionValidatorTestCase {

  @Rule
  public ExpectedException exception = ExpectedException.none();

  @Test
  public void policyDefinitionWithInvalidExtension() throws URISyntaxException {
    exception.expect(OfflinePolicyDeserializationException.class);
    exception.expectMessage(containsString("Invalid extension in"));

    OfflinePolicyDefinitionValidator.validate(getFile("/templates/template.xml"));
  }

  @Test
  public void policyDefinitionFileDoesNotExist() throws URISyntaxException {
    exception.expect(OfflinePolicyDeserializationException.class);
    exception.expectMessage(containsString("does not exist"));

    OfflinePolicyDefinitionValidator.validate(new File("idonotexist.sad"));
  }

  @Test
  public void validPolicyDefinition() throws URISyntaxException {
    OfflinePolicyDefinitionValidator.validate(getFile("/json/full-definition.json"));
  }

  private File getFile(String fileName) throws URISyntaxException {
    return new File(getClass().getResource(fileName).toURI());
  }

}
