/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.pointcut;

import static com.mulesoft.mule.runtime.gw.policies.pointcut.PointcutTestUtils.listenerPointcutParameters;
import static com.mulesoft.mule.runtime.gw.policies.pointcut.PointcutTestUtils.requesterPointcutParameters;
import static com.mulesoft.mule.runtime.gw.reflection.VariableOverride.overrideLogger;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.assertTrue;

import org.mule.runtime.policy.api.PolicyPointcutParameters;
import org.mule.tck.junit4.AbstractMuleTestCase;

import com.mulesoft.anypoint.tests.logger.MockLogger;
import com.mulesoft.anypoint.tests.logger.TraceLine;

import org.junit.Before;
import org.junit.Test;

public class ApiPointcutAdapterTestCase extends AbstractMuleTestCase {

  private static final String POLICY_NAME = "name";
  private static final String FLOW_NAME = "FlowName";
  private static final String FLOW_NAME_LOWER_CASE = "flowname";
  private static final String FLOW_NAME_2 = "otherFlowName";

  private ApiPointcutAdapter pointcut;
  private MockLogger logger;

  @Before
  public void setUp() {
    logger = new MockLogger();
    pointcut = new ApiPointcutAdapter(POLICY_NAME, FLOW_NAME);

    overrideLogger().in(pointcut).with(logger);
  }

  @Test
  public void apiMatchesListenerParameters() {
    PolicyPointcutParameters parameters = listenerPointcutParameters(FLOW_NAME);

    boolean matches = pointcut.matches(parameters);

    assertTrue(matches);
    assertThat(logger.lines(), hasSize(1));
    assertThat(logger.lines().get(0),
               is(new TraceLine("Executing flow matches API's flow {} for policy {}", FLOW_NAME, POLICY_NAME)));
  }

  @Test
  public void apiMatchesRequestParameters() {
    PolicyPointcutParameters parameters = requesterPointcutParameters(FLOW_NAME);

    boolean matches = pointcut.matches(parameters);

    assertTrue(matches);
    assertThat(logger.lines(), hasSize(1));
    assertThat(logger.lines().get(0),
               is(new TraceLine("Executing flow matches API's flow {} for policy {}", FLOW_NAME, POLICY_NAME)));
  }

  @Test
  public void differentFlowNamesDoesNotMatch() {
    PolicyPointcutParameters parameters = listenerPointcutParameters(FLOW_NAME_2);

    boolean matches = pointcut.matches(parameters);

    assertFalse(matches);
    assertThat(logger.lines(), hasSize(1));
    assertThat(logger.lines().get(0),
               is(new TraceLine("Executing flow {} does not match API's flow {} for policy {}", FLOW_NAME_2, FLOW_NAME,
                                POLICY_NAME)));
  }

  @Test
  public void differentFlowNameCasingDoesNotMatch() {
    PolicyPointcutParameters parameters = listenerPointcutParameters(FLOW_NAME_LOWER_CASE);

    boolean matches = pointcut.matches(parameters);

    assertFalse(matches);
    assertThat(logger.lines(), hasSize(1));
    assertThat(logger.lines().get(0),
               is(new TraceLine("Executing flow {} does not match API's flow {} for policy {}", FLOW_NAME_LOWER_CASE,
                                FLOW_NAME, POLICY_NAME)));
  }

}
