/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.pointcut;

import static com.mulesoft.mule.runtime.gw.api.policy.HttpResourcePointcut.HTTP_LISTENER_COMPONENT_IDENTIFIER;
import static com.mulesoft.mule.runtime.gw.api.policy.HttpResourcePointcut.HTTP_REQUEST_COMPONENT_IDENTIFIER;
import static java.util.Collections.singletonList;
import static java.util.Optional.of;
import static javax.xml.namespace.QName.valueOf;

import org.mule.extension.http.api.policy.HttpListenerPolicyPointcutParameters;
import org.mule.extension.http.api.policy.HttpRequestPolicyPointcutParameters;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier.ComponentType;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.policy.api.PolicyPointcutParameters;

import com.google.common.collect.ImmutableMap;

import java.util.Map;
import java.util.Optional;

import javax.xml.namespace.QName;

public class PointcutTestUtils {

  private static final ComponentIdentifier INVALID_COMPONENT_IDENTIFIER =
      ComponentIdentifier.builder().namespace("invalid").name("component").build();

  private static final Optional<String> CONFIG_FILE_NAME = of("test-flow.xml");

  public static PolicyPointcutParameters listenerPointcutParameters(String flowName) {
    Map<QName, Object> annotations = ImmutableMap.of();
    return listenerPointcutParameters(flowName, ".", ".", annotations);
  }

  public static PolicyPointcutParameters annotatedListenerPointcutParameters(String flowName) {
    Map<QName, Object> annotations =
        ImmutableMap.of(valueOf("{http://www.mulesoft.org/schema/mule/api-gateway}disablePolicies"), "true");
    return listenerPointcutParameters(flowName, ".", ".", annotations);
  }

  public static PolicyPointcutParameters listenerPointcutParameters(String flowName, String path, String method,
                                                                    Map<QName, Object> annotations) {
    return new HttpListenerPolicyPointcutParameters(component(flowName, HTTP_LISTENER_COMPONENT_IDENTIFIER, annotations), path,
                                                    method);
  }

  public static PolicyPointcutParameters listenerPointcutParameters(String flowName, String path, String method,
                                                                    String maskedPath, MultiMap<String, String> headers,
                                                                    Map<QName, Object> annotations) {
    return new HttpListenerPolicyPointcutParameters(component(flowName, HTTP_LISTENER_COMPONENT_IDENTIFIER, annotations), path,
                                                    method, maskedPath, headers);
  }

  public static PolicyPointcutParameters requesterPointcutParameters(String flowName) {
    Map<QName, Object> annotations = ImmutableMap.of();
    return requesterPointcutParameters(flowName, "", "", annotations);
  }

  public static PolicyPointcutParameters annotatedRequesterPointcutParameters(String flowName) {
    Map<QName, Object> annotations =
        ImmutableMap.of(valueOf("{http://www.mulesoft.org/schema/mule/api-gateway}disablePolicies"), "true");
    return requesterPointcutParameters(flowName, "", "", annotations);
  }

  public static PolicyPointcutParameters requesterPointcutParameters(String flowName, String path, String method,
                                                                     Map<QName, Object> annotations) {
    return new HttpRequestPolicyPointcutParameters(component(flowName, HTTP_REQUEST_COMPONENT_IDENTIFIER, annotations), path,
                                                   method);
  }

  public static PolicyPointcutParameters nonHttpPointcutParameters(String flowName) {
    Map<QName, Object> annotations = ImmutableMap.of();
    return new PolicyPointcutParameters(component(flowName, INVALID_COMPONENT_IDENTIFIER, annotations));
  }

  public static Component component(String flowName, ComponentIdentifier componentIdentifier, Map<QName, Object> annotations) {
    TypedComponentIdentifier typedComponentIdentifier =
        TypedComponentIdentifier.builder().identifier(componentIdentifier).type(ComponentType.SOURCE).build();

    return component(new DefaultComponentLocation(of(flowName),
                                                  singletonList(new DefaultComponentLocation.DefaultLocationPart(flowName,
                                                                                                                 of(typedComponentIdentifier),
                                                                                                                 CONFIG_FILE_NAME,
                                                                                                                 of(1),
                                                                                                                 of(0)))),
                     annotations);
  }

  private static Component component(final DefaultComponentLocation componentLocation, Map<QName, Object> annots) {
    return new Component() {

      Map<QName, Object> annotations = annots;

      @Override
      public Object getAnnotation(QName qName) {
        return annotations.get(qName);
      }

      @Override
      public Map<QName, Object> getAnnotations() {
        return annotations;
      }

      @Override
      public void setAnnotations(Map<QName, Object> map) {
        throw new RuntimeException("We should not be calling this method");
      }

      @Override
      public ComponentLocation getLocation() {
        return componentLocation;
      }

      @Override
      public Location getRootContainerLocation() {
        throw new RuntimeException("We should not be calling this method");
      }
    };
  }
}
