/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.store;

import static com.mulesoft.mule.runtime.gw.policies.store.EncryptedPropertiesSerializer.ENCRYPTED_PROPERTIES_YAML_FILE_NAME;
import static java.util.Arrays.asList;
import static java.util.Collections.emptyMap;
import static org.apache.commons.io.FileUtils.readFileToString;
import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;

import org.mule.tck.junit4.AbstractMuleTestCase;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class EncryptedPropertiesSerializerTestCase extends AbstractMuleTestCase {

  private static final String STRING_PROPERTY = "String";
  private static final String STRINGS_PROPERTY = "Strings";
  private static final String KEYVALUE_PROPERTY = "Keyvalue";
  private static final String KEYVALUES_PROPERTY = "Keyvalues";

  private static final String KEY = "someKey";
  private static final String KEY_2 = "anotherKey";
  private static final String VALUE = "someValue";
  private static final String VALUE_2 = "anotherValue";

  @Rule
  public TemporaryFolder temporaryFolder = new TemporaryFolder();

  private EncryptedPropertiesSerializer serializer;
  private File destFolder;

  @Before
  public void setUp() throws IOException {
    serializer = new EncryptedPropertiesSerializer();
    destFolder = temporaryFolder.newFolder();
  }

  @Test
  public void serializeWhenSmartEncryption() throws IOException, URISyntaxException {

    serializer.store(configData(), destFolder);

    File expected = new File(getClass().getResource("/properties/properties.yaml").toURI());

    assertThat(readFileToString(yaml()), is(readFileToString(expected)));
  }

  @Test
  public void serializeWhenNoConfigData() throws IOException {

    serializer.store(emptyMap(), destFolder);

    assertThat(yaml().exists(), is(false));
  }

  @Test
  public void serializeWhenNoConfigDataAndExistentFileIsDeleted() throws IOException {
    serializer.store(configData(), destFolder);

    serializer.store(emptyMap(), destFolder);

    assertThat(yaml().exists(), is(false));
  }

  private Map<String, Object> configData() {
    Map<String, String> propertyMap = new HashMap<>();
    propertyMap.put("key", KEY);
    propertyMap.put("value", VALUE);
    Map<String, String> propertyMap2 = new HashMap<>();
    propertyMap2.put("key", KEY_2);
    propertyMap2.put("value", VALUE_2);

    Map<String, Object> configData = new HashMap<>();
    configData.put(STRING_PROPERTY, VALUE);
    configData.put(STRINGS_PROPERTY, asList(VALUE, VALUE_2));
    configData.put(KEYVALUE_PROPERTY, propertyMap);
    configData.put(KEYVALUES_PROPERTY, asList(propertyMap, propertyMap2));

    return configData;
  }

  private File yaml() {
    return new File(destFolder, ENCRYPTED_PROPERTIES_YAML_FILE_NAME);
  }
}
