/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.store;

import static com.mulesoft.mule.runtime.gw.api.PolicyFolders.getOfflinePoliciesFolder;
import static com.mulesoft.mule.runtime.gw.api.PolicyFolders.getPolicyTemplatesFolder;
import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;
import static org.mule.runtime.core.api.config.MuleProperties.MULE_HOME_DIRECTORY_PROPERTY;

import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemPropertyTemporaryFolder;

import java.io.File;
import java.io.IOException;
import java.util.List;

import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class PolicyStoreFilesTestCase extends AbstractMuleTestCase {

  private static final String POLICY_NAME = "policy-name";

  @Rule
  public TemporaryFolder muleHome = new SystemPropertyTemporaryFolder(MULE_HOME_DIRECTORY_PROPERTY);

  private PolicyStoreFiles fileHandler;

  @Before
  public void setUp() throws IOException {
    fileHandler = new PolicyStoreFiles(muleHome.newFolder());
  }

  @Test
  public void listPolicyFoldersOnlyReturnsPolicyFolders() {
    getPolicyTemplatesFolder();
    getOfflinePoliciesFolder();
    fileHandler.getFailedPoliciesFolder().mkdir();
    fileHandler.getPolicyFolder(POLICY_NAME).mkdir();

    List<File> folders = fileHandler.listPolicyFolders();

    assertThat(folders, hasSize(1));
    assertThat(folders.get(0).getName(), is(POLICY_NAME));
  }

  @Test
  public void listFailedPolicyFoldersReturnsEmptyWhenFailedPoliciesFolderDoesNotExist() {
    getPolicyTemplatesFolder();
    fileHandler.getPolicyFolder(POLICY_NAME).mkdir();

    List<File> files = fileHandler.listPolicyDeploymentFailures();

    assertThat(files, empty());
  }

  @Test
  public void getFailedPoliciesFolderDoesNotCreateIt() {

    File folder = fileHandler.getFailedPoliciesFolder();

    assertThat(folder.exists(), is(false));
  }
}
