/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.factory;

import com.google.common.collect.ImmutableMap;
import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.anypoint.tests.logger.DebugLine;
import com.mulesoft.anypoint.tests.logger.MockLogger;
import com.mulesoft.mule.runtime.gw.api.policy.HttpResourcePointcut;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyParametrizationFactory;
import com.mulesoft.mule.runtime.gw.policies.pointcut.CompositePointcut;
import com.mulesoft.mule.runtime.gw.policies.pointcut.HttpHeaderPointcut;
import com.mulesoft.mule.runtime.gw.policies.pointcut.PointcutTestUtils;
import com.mulesoft.mule.runtime.gw.reflection.VariableOverride;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import javax.xml.namespace.QName;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.policy.PolicyParametrization;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;
import org.mule.runtime.policy.api.PolicyPointcut;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemPropertyTemporaryFolder;

public class PolicyParametrizationFactoryTestCase
extends AbstractMuleTestCase {
    private static final String FLOW_NAME = "flowName";
    private static final String INVALID_FLOW_NAME = "invalidFlowName";
    private static final String IS_WSDL_ENDPOINT = "isWsdlEndpoint";
    private static final String API_ID = "apiId";
    private static final String HDP_SERVICE_HEADER = "X-MULE-HDP-SERVICE";
    private static final String HDP_SERVICE = "svc";
    private static final String PATH = "/base/path/resource/1";
    private static final String MASKED_PATH = "/resource/1";
    @Rule
    public TemporaryFolder muleHome = new SystemPropertyTemporaryFolder("mule.home");
    private File file;
    private NotificationListener listener;
    private ApiImplementation apiImplementation;
    private PolicyDefinition policyDefinition;
    private MockLogger logger;
    private PolicyParametrizationFactory factory = new PolicyParametrizationFactory();

    @Before
    public void setUp() {
        this.file = (File)Mockito.mock(File.class);
        this.listener = (NotificationListener)Mockito.mock(NotificationListener.class);
        this.logger = new MockLogger();
        VariableOverride.overrideLogger().in((Object)this.factory).with((Object)this.logger);
        this.apiImplementation = this.getApiImplementation();
    }

    @Test
    public void createWithOnlyApiPointcut() {
        this.policyDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 1, new PolicyConfiguration(Collections.emptyMap()));
        PolicyParametrization parametrization = this.factory.create(this.policyDefinition, this.apiImplementation, this.file, null, Collections.singletonList(this.listener));
        Assert.assertThat((Object)parametrization.getPolicyPointcut(), (Matcher)IsInstanceOf.instanceOf(CompositePointcut.class));
        this.assertBasicPointcutPresent(parametrization.getPolicyPointcut());
        this.assertResourcePointcutsNotPresent(parametrization.getPolicyPointcut());
        Assert.assertThat((Object)parametrization.getId(), (Matcher)Is.is((Object)(this.policyDefinition.getName() + "-" + FLOW_NAME)));
        Assert.assertThat((Object)parametrization.getOrder(), (Matcher)Is.is((Object)this.policyDefinition.getOrder()));
        Assert.assertThat((Object)parametrization.getConfig(), (Matcher)Is.is((Object)this.file));
        Assert.assertThat(parametrization.getParameters().get(API_ID), (Matcher)Is.is((Object)PolicyTestValuesConstants.API_KEY.id().toString()));
        Assert.assertThat(parametrization.getParameters().get(IS_WSDL_ENDPOINT), (Matcher)Is.is((Object)"false"));
        Assert.assertThat((Object)parametrization.getNotificationListeners(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)parametrization.getNotificationListeners(), (Matcher)Matchers.hasItem((Object)this.listener));
        Assert.assertThat((Object)this.logger.lines(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(this.logger.lines().get(0), (Matcher)Is.is((Object)new DebugLine("There are no resource pointcuts defined for policy {}. It will be applied to flow {}", new Object[]{this.policyDefinition.getName(), FLOW_NAME})));
    }

    @Test
    public void createWithApiAndResourcePointcuts() {
        this.policyDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, PolicyTestValuesConstants.RESOURCE_POINTCUTS, 1, new PolicyConfiguration(Collections.emptyMap()));
        PolicyParametrization parametrization = this.factory.create(this.policyDefinition, this.apiImplementation, this.file, null, Collections.singletonList(this.listener));
        Assert.assertThat((Object)parametrization.getPolicyPointcut(), (Matcher)IsInstanceOf.instanceOf(CompositePointcut.class));
        this.assertBasicPointcutPresent(parametrization.getPolicyPointcut());
        this.assertResourcePointcutsPresent(parametrization.getPolicyPointcut());
        Assert.assertThat((Object)parametrization.getId(), (Matcher)Is.is((Object)(this.policyDefinition.getName() + "-" + FLOW_NAME)));
        Assert.assertThat((Object)parametrization.getOrder(), (Matcher)Is.is((Object)this.policyDefinition.getOrder()));
        Assert.assertThat((Object)parametrization.getConfig(), (Matcher)Is.is((Object)this.file));
        Assert.assertThat(parametrization.getParameters().get(API_ID), (Matcher)Is.is((Object)PolicyTestValuesConstants.API_KEY.id().toString()));
        Assert.assertThat((Object)parametrization.getNotificationListeners(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)parametrization.getNotificationListeners(), (Matcher)Matchers.hasItem((Object)this.listener));
    }

    @Test
    public void createWithIsWsdlEndpointAsString() {
        ImmutableMap configData = ImmutableMap.of((Object)IS_WSDL_ENDPOINT, (Object)"true");
        this.policyDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 1, new PolicyConfiguration((Map)configData));
        PolicyParametrization parametrization = this.factory.create(this.policyDefinition, this.apiImplementation, this.file, null, Collections.singletonList(this.listener));
        Assert.assertThat((Object)parametrization.getPolicyPointcut(), (Matcher)IsInstanceOf.instanceOf(CompositePointcut.class));
        Assert.assertThat((Object)parametrization.getId(), (Matcher)Is.is((Object)(this.policyDefinition.getName() + "-" + FLOW_NAME)));
        Assert.assertThat((Object)parametrization.getOrder(), (Matcher)Is.is((Object)this.policyDefinition.getOrder()));
        Assert.assertThat((Object)parametrization.getConfig(), (Matcher)Is.is((Object)this.file));
        Assert.assertThat(parametrization.getParameters().get(API_ID), (Matcher)Is.is((Object)PolicyTestValuesConstants.API_KEY.id().toString()));
        Assert.assertThat(parametrization.getParameters().get(IS_WSDL_ENDPOINT), (Matcher)Is.is((Object)"true"));
        Assert.assertThat((Object)parametrization.getNotificationListeners(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)parametrization.getNotificationListeners(), (Matcher)Matchers.hasItem((Object)this.listener));
        Assert.assertThat((Object)this.logger.lines(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(this.logger.lines().get(0), (Matcher)Is.is((Object)new DebugLine("There are no resource pointcuts defined for policy {}. It will be applied to flow {}", new Object[]{this.policyDefinition.getName(), FLOW_NAME})));
    }

    @Test
    public void createWithIsWsdlEndpointAsBoolean() {
        ImmutableMap configData = ImmutableMap.of((Object)IS_WSDL_ENDPOINT, (Object)true);
        this.policyDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 1, new PolicyConfiguration((Map)configData));
        PolicyParametrization parametrization = this.factory.create(this.policyDefinition, this.apiImplementation, this.file, null, Collections.singletonList(this.listener));
        Assert.assertThat((Object)parametrization.getPolicyPointcut(), (Matcher)IsInstanceOf.instanceOf(CompositePointcut.class));
        Assert.assertThat((Object)parametrization.getId(), (Matcher)Is.is((Object)(this.policyDefinition.getName() + "-" + FLOW_NAME)));
        Assert.assertThat((Object)parametrization.getOrder(), (Matcher)Is.is((Object)this.policyDefinition.getOrder()));
        Assert.assertThat((Object)parametrization.getConfig(), (Matcher)Is.is((Object)this.file));
        Assert.assertThat(parametrization.getParameters().get(API_ID), (Matcher)Is.is((Object)PolicyTestValuesConstants.API_KEY.id().toString()));
        Assert.assertThat(parametrization.getParameters().get(IS_WSDL_ENDPOINT), (Matcher)Is.is((Object)"true"));
        Assert.assertThat((Object)parametrization.getNotificationListeners(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)parametrization.getNotificationListeners(), (Matcher)Matchers.hasItem((Object)this.listener));
        Assert.assertThat((Object)this.logger.lines(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(this.logger.lines().get(0), (Matcher)Is.is((Object)new DebugLine("There are no resource pointcuts defined for policy {}. It will be applied to flow {}", new Object[]{this.policyDefinition.getName(), FLOW_NAME})));
    }

    @Test
    public void createWithHdpPointcut() {
        this.apiImplementation = this.getApiImplementation(HDP_SERVICE);
        this.policyDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 1, new PolicyConfiguration(Collections.emptyMap()));
        PolicyParametrization parametrization = this.factory.create(this.policyDefinition, this.apiImplementation, this.file, null, Collections.singletonList(this.listener));
        Assert.assertThat((Object)parametrization.getPolicyPointcut(), (Matcher)IsInstanceOf.instanceOf(CompositePointcut.class));
        this.assertHdpPointcutPresent(parametrization.getPolicyPointcut());
        this.assertHdpResourcePointcutsNotPresent(parametrization.getPolicyPointcut());
        Assert.assertThat((Object)parametrization.getId(), (Matcher)Is.is((Object)(this.policyDefinition.getName() + "-" + FLOW_NAME)));
        Assert.assertThat((Object)parametrization.getOrder(), (Matcher)Is.is((Object)this.policyDefinition.getOrder()));
        Assert.assertThat((Object)parametrization.getConfig(), (Matcher)Is.is((Object)this.file));
        Assert.assertThat(parametrization.getParameters().get(API_ID), (Matcher)Is.is((Object)PolicyTestValuesConstants.API_KEY.id().toString()));
        Assert.assertThat(parametrization.getParameters().get(IS_WSDL_ENDPOINT), (Matcher)Is.is((Object)"false"));
        Assert.assertThat((Object)parametrization.getNotificationListeners(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)parametrization.getNotificationListeners(), (Matcher)Matchers.hasItem((Object)this.listener));
        Assert.assertThat((Object)this.logger.lines(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat(this.logger.lines().get(0), (Matcher)Is.is((Object)new DebugLine("Injecting header pointcut {} for service {}", new Object[]{new HttpHeaderPointcut("policyId", HDP_SERVICE_HEADER, HDP_SERVICE).toString(), HDP_SERVICE})));
        Assert.assertThat(this.logger.lines().get(1), (Matcher)Is.is((Object)new DebugLine("There are no resource pointcuts defined for policy {}. It will be applied to flow {}", new Object[]{this.policyDefinition.getName(), FLOW_NAME})));
    }

    @Test
    public void createWithHdpAndResourcePointcuts() {
        this.apiImplementation = this.getApiImplementation(HDP_SERVICE);
        this.policyDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, PolicyTestValuesConstants.RESOURCE_POINTCUTS, 1, new PolicyConfiguration(Collections.emptyMap()));
        PolicyParametrization parametrization = this.factory.create(this.policyDefinition, this.apiImplementation, this.file, null, Collections.singletonList(this.listener));
        Assert.assertThat((Object)parametrization.getPolicyPointcut(), (Matcher)IsInstanceOf.instanceOf(CompositePointcut.class));
        this.assertHdpPointcutPresent(parametrization.getPolicyPointcut());
        this.assertHdpResourcePointcutsPresent(parametrization.getPolicyPointcut());
        Assert.assertThat((Object)parametrization.getId(), (Matcher)Is.is((Object)(this.policyDefinition.getName() + "-" + FLOW_NAME)));
        Assert.assertThat((Object)parametrization.getOrder(), (Matcher)Is.is((Object)this.policyDefinition.getOrder()));
        Assert.assertThat((Object)parametrization.getConfig(), (Matcher)Is.is((Object)this.file));
        Assert.assertThat(parametrization.getParameters().get(API_ID), (Matcher)Is.is((Object)PolicyTestValuesConstants.API_KEY.id().toString()));
        Assert.assertThat((Object)parametrization.getNotificationListeners(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)parametrization.getNotificationListeners(), (Matcher)Matchers.hasItem((Object)this.listener));
        Assert.assertThat((Object)this.logger.lines(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(this.logger.lines().get(0), (Matcher)Is.is((Object)new DebugLine("Injecting header pointcut {} for service {}", new Object[]{new HttpHeaderPointcut("policyId", HDP_SERVICE_HEADER, HDP_SERVICE).toString(), HDP_SERVICE})));
    }

    @Test
    public void createWithResourcePointcutUsingMaskedPath() {
        this.apiImplementation = this.getApiImplementation(null, true);
        this.policyDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, Collections.singletonList(new HttpResourcePointcut("/resource/.*", ".*")), 1, new PolicyConfiguration(Collections.emptyMap()));
        PolicyParametrization parametrization = this.factory.create(this.policyDefinition, this.apiImplementation, this.file, null, Collections.singletonList(this.listener));
        Assert.assertThat((Object)parametrization.getPolicyPointcut(), (Matcher)IsInstanceOf.instanceOf(CompositePointcut.class));
        this.assertMaskedPathResourcePointcutsPresent(parametrization.getPolicyPointcut());
        Assert.assertThat((Object)parametrization.getId(), (Matcher)Is.is((Object)(this.policyDefinition.getName() + "-" + FLOW_NAME)));
        Assert.assertThat((Object)parametrization.getOrder(), (Matcher)Is.is((Object)this.policyDefinition.getOrder()));
        Assert.assertThat((Object)parametrization.getConfig(), (Matcher)Is.is((Object)this.file));
        Assert.assertThat(parametrization.getParameters().get(API_ID), (Matcher)Is.is((Object)PolicyTestValuesConstants.API_KEY.id().toString()));
        Assert.assertThat((Object)parametrization.getNotificationListeners(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)parametrization.getNotificationListeners(), (Matcher)Matchers.hasItem((Object)this.listener));
    }

    private void assertBasicPointcutPresent(PolicyPointcut policyPointcut) {
        ImmutableMap annotations = ImmutableMap.of();
        Assert.assertThat((Object)policyPointcut.matches(PointcutTestUtils.listenerPointcutParameters(FLOW_NAME, PATH, "GET", (Map<QName, Object>)annotations)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)policyPointcut.matches(PointcutTestUtils.listenerPointcutParameters(INVALID_FLOW_NAME, PATH, "GET", (Map<QName, Object>)annotations)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)policyPointcut.matches(PointcutTestUtils.nonHttpPointcutParameters(FLOW_NAME)), (Matcher)Is.is((Object)false));
    }

    private void assertResourcePointcutsPresent(PolicyPointcut policyPointcut) {
        ImmutableMap annotations = ImmutableMap.of();
        Assert.assertThat((Object)policyPointcut.matches(PointcutTestUtils.listenerPointcutParameters(FLOW_NAME, PATH, "HEAD", (Map<QName, Object>)annotations)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)policyPointcut.matches(PointcutTestUtils.listenerPointcutParameters(FLOW_NAME, PATH, "GET", (Map<QName, Object>)annotations)), (Matcher)Is.is((Object)true));
    }

    private void assertMaskedPathResourcePointcutsPresent(PolicyPointcut policyPointcut) {
        ImmutableMap annotations = ImmutableMap.of();
        Assert.assertThat((Object)policyPointcut.matches(PointcutTestUtils.listenerPointcutParameters(FLOW_NAME, PATH, "HEAD", MASKED_PATH, (MultiMap<String, String>)MultiMap.emptyMultiMap(), (Map<QName, Object>)annotations)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)policyPointcut.matches(PointcutTestUtils.listenerPointcutParameters(FLOW_NAME, MASKED_PATH, "HEAD", "/1", (MultiMap<String, String>)MultiMap.emptyMultiMap(), (Map<QName, Object>)annotations)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)policyPointcut.matches(PointcutTestUtils.listenerPointcutParameters(INVALID_FLOW_NAME, PATH, "HEAD", MASKED_PATH, (MultiMap<String, String>)MultiMap.emptyMultiMap(), (Map<QName, Object>)annotations)), (Matcher)Is.is((Object)false));
    }

    private void assertResourcePointcutsNotPresent(PolicyPointcut policyPointcut) {
        ImmutableMap annotations = ImmutableMap.of();
        Assert.assertThat((Object)policyPointcut.matches(PointcutTestUtils.listenerPointcutParameters(FLOW_NAME, PATH, "HEAD", (Map<QName, Object>)annotations)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)policyPointcut.matches(PointcutTestUtils.listenerPointcutParameters(FLOW_NAME, PATH, "GET", (Map<QName, Object>)annotations)), (Matcher)Is.is((Object)true));
    }

    private void assertHdpPointcutPresent(PolicyPointcut policyPointcut) {
        ImmutableMap annotations = ImmutableMap.of();
        Assert.assertThat((Object)policyPointcut.matches(PointcutTestUtils.listenerPointcutParameters(FLOW_NAME, PATH, "GET", null, this.getHdpHeader(), (Map<QName, Object>)annotations)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)policyPointcut.matches(PointcutTestUtils.listenerPointcutParameters(INVALID_FLOW_NAME, PATH, "GET", null, this.getHdpHeader(), (Map<QName, Object>)annotations)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)policyPointcut.matches(PointcutTestUtils.nonHttpPointcutParameters(FLOW_NAME)), (Matcher)Is.is((Object)false));
    }

    private void assertHdpResourcePointcutsPresent(PolicyPointcut policyPointcut) {
        ImmutableMap annotations = ImmutableMap.of();
        Assert.assertThat((Object)policyPointcut.matches(PointcutTestUtils.listenerPointcutParameters(FLOW_NAME, PATH, "HEAD", null, this.getHdpHeader(), (Map<QName, Object>)annotations)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)policyPointcut.matches(PointcutTestUtils.listenerPointcutParameters(FLOW_NAME, PATH, "GET", null, this.getHdpHeader(), (Map<QName, Object>)annotations)), (Matcher)Is.is((Object)true));
    }

    private void assertHdpResourcePointcutsNotPresent(PolicyPointcut policyPointcut) {
        ImmutableMap annotations = ImmutableMap.of();
        Assert.assertThat((Object)policyPointcut.matches(PointcutTestUtils.listenerPointcutParameters(FLOW_NAME, PATH, "HEAD", null, this.getHdpHeader(), (Map<QName, Object>)annotations)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)policyPointcut.matches(PointcutTestUtils.listenerPointcutParameters(FLOW_NAME, PATH, "GET", null, this.getHdpHeader(), (Map<QName, Object>)annotations)), (Matcher)Is.is((Object)true));
    }

    private MultiMap<String, String> getHdpHeader() {
        return new CaseInsensitiveMultiMap(new MultiMap((Map)ImmutableMap.of((Object)HDP_SERVICE_HEADER, (Object)HDP_SERVICE)));
    }

    private ApiImplementation getApiImplementation() {
        return this.getApiImplementation(null);
    }

    private ApiImplementation getApiImplementation(String hdpService) {
        return this.getApiImplementation(hdpService, false);
    }

    private ApiImplementation getApiImplementation(String hdpService, boolean ignoreBasePathOnResourceLevel) {
        Application application = (Application)Mockito.mock(Application.class);
        Flow flow = (Flow)Mockito.mock(Flow.class);
        Mockito.when((Object)flow.getName()).thenReturn((Object)FLOW_NAME);
        return new ApiImplementation(PolicyTestValuesConstants.API_KEY, application, flow, hdpService, ignoreBasePathOnResourceLevel);
    }
}

