/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.lifecycle;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.gatekeeper.status.GatekeeperStatusTracker;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import com.mulesoft.mule.runtime.gw.policies.deployment.PolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.BlockingGateKeeper;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.FlexibleGateKeeper;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.GateKeeper;
import com.mulesoft.mule.runtime.gw.policies.template.PolicyTemplate;
import com.mulesoft.mule.runtime.gw.reflection.VariableOverride;
import java.lang.reflect.Method;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class GatekeeperPolicyIdTestCase {
    private static final String RESOLVED_TEMPLATE = "resolvedTemplate";
    @Captor
    private ArgumentCaptor<PolicyDefinition> captor;
    private Long apiId = 101L;
    private ApiKey apiKey = (ApiKey)Mockito.mock(ApiKey.class);
    private ApiImplementation apiImplementation = (ApiImplementation)Mockito.mock(ApiImplementation.class);
    private Api api = (Api)Mockito.mock(Api.class);
    private PolicyDeployer policyDeployer = (PolicyDeployer)Mockito.mock(PolicyDeployer.class);
    private ApiService apiService = (ApiService)Mockito.mock(ApiService.class);
    private String policyId = "gatekeeper-" + this.apiId;
    @Mock
    private PolicyTemplate policyTemplate;
    @Mock
    private PolicyFactory policyFactory;
    private Policy policy;
    private GateKeeper gateKeeper;

    @Before
    public void setup() {
        this.gateKeeper = new FlexibleGateKeeper(this.apiService, this.policyFactory);
        GatekeeperStatusTracker status = (GatekeeperStatusTracker)Mockito.mock(GatekeeperStatusTracker.class);
        Mockito.when((Object)this.apiKey.id()).thenReturn((Object)this.apiId);
        Mockito.when((Object)this.apiImplementation.gatekeeperStatus()).thenReturn((Object)status);
        Mockito.when((Object)status.isBlocked()).thenReturn((Object)false);
        Mockito.when((Object)this.api.getImplementation()).thenReturn((Object)this.apiImplementation);
        Mockito.when((Object)this.api.getKey()).thenReturn((Object)this.apiKey);
        VariableOverride.overrideVariable((String)"policyDeployer").in((Object)this.gateKeeper).with((Object)this.policyDeployer);
        PolicyDefinition policyDefinition = (PolicyDefinition)this.captor.capture();
        this.policy = new Policy(this.policyTemplate, policyDefinition, RESOLVED_TEMPLATE);
        Mockito.when((Object)this.policyFactory.createFromPolicyDefinition(policyDefinition)).thenReturn((Object)this.policy);
    }

    @Test
    public void blockApi() throws Exception {
        this.execute("doBlockApi");
        ((PolicyDeployer)Mockito.verify((Object)this.policyDeployer)).deploy(this.policy, this.api);
        Assert.assertThat((Object)((PolicyDefinition)this.captor.getValue()).getId(), (Matcher)CoreMatchers.is((Object)this.policyId));
    }

    @Test
    public void unblockApi() throws Exception {
        this.execute("unblockApi");
        ((PolicyDeployer)Mockito.verify((Object)this.policyDeployer)).undeploy(this.policyId, this.api);
    }

    private void execute(String method) throws Exception {
        Method m = BlockingGateKeeper.class.getDeclaredMethod(method, Api.class);
        m.setAccessible(true);
        m.invoke((Object)this.gateKeeper, this.api);
    }
}

