/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.offline;

import com.mulesoft.mule.runtime.gw.policies.offline.OfflinePolicyDefinitionValidator;
import com.mulesoft.mule.runtime.gw.policies.serialization.OfflinePolicyDeserializationException;
import java.io.File;
import java.net.URISyntaxException;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class OfflinePolicyDefinitionValidatorTestCase {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void policyDefinitionWithInvalidExtension() throws URISyntaxException {
        this.exception.expect(OfflinePolicyDeserializationException.class);
        this.exception.expectMessage(Matchers.containsString((String)"Invalid extension in"));
        OfflinePolicyDefinitionValidator.validate((File)this.getFile("/templates/template.xml"));
    }

    @Test
    public void policyDefinitionFileDoesNotExist() throws URISyntaxException {
        this.exception.expect(OfflinePolicyDeserializationException.class);
        this.exception.expectMessage(Matchers.containsString((String)"does not exist"));
        OfflinePolicyDefinitionValidator.validate((File)new File("idonotexist.sad"));
    }

    @Test
    public void validPolicyDefinition() throws URISyntaxException {
        OfflinePolicyDefinitionValidator.validate((File)this.getFile("/json/full-definition.json"));
    }

    private File getFile(String fileName) throws URISyntaxException {
        return new File(this.getClass().getResource(fileName).toURI());
    }
}

