/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.deployment;

import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStore;
import org.slf4j.Logger;

public class DeploymentExceptionHandler {
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(DeploymentExceptionHandler.class);
    private PolicyStore policyStore;

    public DeploymentExceptionHandler(PolicyStore policyStore) {
        this.policyStore = policyStore;
    }

    public void handle(PolicyDefinition policyDefinition, ApiImplementation implementation, Exception exception) {
        this.logDeploymentError(policyDefinition.getName(), implementation.getArtifactName(), exception);
        this.policyStore.storeDeploymentFailure(policyDefinition, implementation.getApiKey(), exception);
    }

    private void logDeploymentError(String policyName, String appName, Exception e) {
        LOGGER.error("Error deploying policy " + policyName + " to application " + appName, (Throwable)e);
    }
}

