/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.service;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.deployment.DeploymentExceptionHandler;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.PolicySetDeploymentListener;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.policies.service.PolicySetDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStore;
import com.mulesoft.mule.runtime.gw.policies.template.exception.PolicyTemplateException;
import com.mulesoft.mule.runtime.gw.retry.RunnableRetrier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class DefaultPolicySetDeploymentService
implements PolicySetDeploymentService {
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(DefaultPolicySetDeploymentService.class);
    private final RunnableRetrier<ApiKey> runnableRetrier;
    private final PolicyDeploymentService policyDeploymentService;
    private final PolicyDeploymentTracker policyDeploymentTracker;
    private final PolicyStore policyStore;
    private final List<PolicySetDeploymentListener> deploymentListeners = new CopyOnWriteArrayList<PolicySetDeploymentListener>();
    private final PolicyFactory policyFactory;
    private final ApiService apiService;

    public DefaultPolicySetDeploymentService(RunnableRetrier<ApiKey> policySetRetrier, PolicyDeploymentService policyDeploymentService, PolicyDeploymentTracker policyDeploymentTracker, PolicyStore policyStore, PolicyFactory policyFactory, ApiService apiService) {
        this.runnableRetrier = policySetRetrier;
        this.policyDeploymentService = policyDeploymentService;
        this.policyDeploymentTracker = policyDeploymentTracker;
        this.policyStore = policyStore;
        this.policyFactory = policyFactory;
        this.apiService = apiService;
    }

    @Override
    public synchronized void policiesForApi(ApiKey apiKey, PolicySet policySet) {
        this.runnableRetrier.scheduleRetry((Object)apiKey, () -> {
            this.logPoliciesForApi(apiKey, policySet);
            this.updatePolicies(apiKey, policySet);
            if (this.failedDownloadTemplates(apiKey).size() != 0) {
                LOGGER.debug("Template download failed for API {} - Policies {}.", (Object)apiKey, this.names(this.failedDownloadTemplates(apiKey)));
                throw new RuntimeException("There are still failures in template downloading");
            }
            this.notifyPolicySetDeployed(apiKey, policySet);
        });
    }

    @Override
    public void removeAll(ApiKey apiKey) {
        LOGGER.debug("Removing all policies from API {}", (Object)apiKey);
        this.notifyAllPoliciesRemoved(apiKey);
        List<Policy> policiesToRemove = this.policyDeploymentTracker.apiRemoved(apiKey);
        policiesToRemove.forEach(this.policyDeploymentService::removePolicy);
    }

    public void onApiDeploymentSuccess(Api api) {
        this.policyStore.offlinePolicies().forEach(policyDefinition -> this.policyDeploymentService.newPolicyForApi(this.policyFactory.createFromPolicyDefinition((PolicyDefinition)policyDefinition), api.getKey()));
    }

    public void onApiUndeploymentStart(ApiImplementation implementation) {
        this.removeAll(implementation.getApiKey());
    }

    public void onApiRedeploymentStart(ApiImplementation implementation) {
        this.notifyAllPoliciesRemoved(implementation.getApiKey());
        this.policyDeploymentTracker.apiRemoved(implementation.getApiKey());
    }

    @Override
    public void addPolicyDeploymentListener(PolicySetDeploymentListener listener) {
        this.deploymentListeners.add(listener);
    }

    @Override
    public void conciliatePolicies(ApiKey apiKey, List<PolicyDefinition> desiredPolicies) {
        List<PolicyDefinition> actualPolicies = this.filterByApi(this.policyStore.onlinePolicies(), apiKey);
        actualPolicies.stream().filter(policyDefinition -> !desiredPolicies.contains(policyDefinition)).forEach(policyDefinition -> this.policyStore.remove(policyDefinition.getName()));
        desiredPolicies.stream().filter(policyDefinition -> !actualPolicies.contains(policyDefinition)).forEach(policyDefinition -> this.policyStore.store((PolicyDefinition)policyDefinition));
    }

    @Override
    public Map<ApiKey, List<PolicyDefinition>> storedOnlinePoliciesByApi() {
        HashMap<ApiKey, List<PolicyDefinition>> groupedPolicies = new HashMap<ApiKey, List<PolicyDefinition>>();
        this.policyStore.onlinePolicies().forEach(policyDefinition -> policyDefinition.getApiKeys().forEach(apiKey -> {
            groupedPolicies.putIfAbsent((ApiKey)apiKey, new ArrayList());
            ((List)groupedPolicies.get(apiKey)).add(policyDefinition);
        }));
        return groupedPolicies;
    }

    private void logPoliciesForApi(ApiKey apiKey, PolicySet policySet) {
        if (LOGGER.isDebugEnabled()) {
            List policyNames = policySet.getPolicyDefinitions().stream().map(PolicyDefinition::getName).collect(Collectors.toList());
            LOGGER.debug("Deploying policies {} from {} to API {}", new Object[]{policyNames, policySet.isFromPlatform() ? "Platform" : "File System", apiKey});
        }
    }

    private void updatePolicies(ApiKey apiKey, PolicySet policySet) {
        List<PolicyDeploymentStatus> oldTrackingStatuses = this.policyDeploymentTracker.onlinePolicyStatuses(apiKey);
        for (PolicyDefinition policyDefinition : policySet.getPolicyDefinitions()) {
            Optional<PolicyDeploymentStatus> oldStatus = oldTrackingStatuses.stream().filter(status -> this.samePolicyName((PolicyDeploymentStatus)status, policyDefinition)).findFirst();
            try {
                Policy policy = this.policyFactory.createFromPolicyDefinition(policyDefinition);
                if (!oldStatus.isPresent()) {
                    LOGGER.debug("New policy {} detected to apply", (Object)policyDefinition.getName());
                    this.policyDeploymentService.newPolicy(policy);
                    continue;
                }
                if (oldStatus.get().getPolicy().getPolicyDefinition().equals((Object)policy.getPolicyDefinition()) && !oldStatus.get().isTemplateDownloadFailed()) continue;
                LOGGER.debug("Update on policy {} detected", (Object)policyDefinition.getName());
                this.policyDeploymentService.updatePolicy(policy);
            }
            catch (PolicyTemplateException exception) {
                this.handleDeploymentException(policyDefinition, exception.status(), apiKey, exception);
            }
            catch (Exception exception) {
                this.handleDeploymentException(policyDefinition, PolicyDeploymentStatus.DeploymentStatus.DEPLOYMENT_FAILED, apiKey, exception);
            }
        }
        this.removeOldPolicies(policySet, oldTrackingStatuses);
    }

    private void notifyAllPoliciesRemoved(ApiKey apiKey) {
        this.deploymentListeners.forEach(policyDeploymentListener -> {
            try {
                policyDeploymentListener.onPoliciesRemoved(apiKey);
            }
            catch (Exception e) {
                LOGGER.warn("Error on polices removed listener: {}", (Object)e.getMessage());
            }
        });
    }

    private void removeOldPolicies(PolicySet policySet, List<PolicyDeploymentStatus> oldTrackingStatuses) {
        oldTrackingStatuses.stream().filter(status -> policySet.getPolicyDefinitions().stream().noneMatch(policyDefinition -> this.samePolicyName((PolicyDeploymentStatus)status, (PolicyDefinition)policyDefinition))).forEach(status -> {
            LOGGER.debug("Policy {} no longer present, it will be removed", (Object)status.getPolicy().getPolicyDefinition().getName());
            this.policyDeploymentService.removePolicy(status.getPolicy().getPolicyDefinition().getName());
        });
    }

    private void notifyPolicySetDeployed(ApiKey apiKey, PolicySet policySet) {
        this.deploymentListeners.forEach(policyDeploymentListener -> {
            try {
                policyDeploymentListener.onPolicySetDeploymentCompleted(apiKey, policySet, this.policyDeploymentTracker.onlinePolicyStatuses(apiKey));
            }
            catch (Exception e) {
                LOGGER.warn("Error on policy deployment completed listener: {}", (Object)e.getMessage());
            }
        });
    }

    private boolean samePolicyName(PolicyDeploymentStatus status, PolicyDefinition policyDefinition) {
        return policyDefinition.getName().equals(status.getPolicy().getPolicyDefinition().getName());
    }

    private List<PolicyDefinition> filterByApi(List<PolicyDefinition> policyDefinitions, ApiKey apiKey) {
        return policyDefinitions.stream().filter(policyDefinition -> policyDefinition.getApiKeys().contains(apiKey)).collect(Collectors.toList());
    }

    private List<String> names(List<PolicyDeploymentStatus> policyDeploymentStatuses) {
        return policyDeploymentStatuses.stream().map(status -> status.getPolicy().getPolicyDefinition().getName()).collect(Collectors.toList());
    }

    private List<PolicyDeploymentStatus> failedDownloadTemplates(ApiKey apiKey) {
        return this.policyDeploymentTracker.onlinePolicyStatuses(apiKey).stream().filter(PolicyDeploymentStatus::isTemplateDownloadFailed).collect(Collectors.toList());
    }

    private void handleDeploymentException(PolicyDefinition policyDefinition, PolicyDeploymentStatus.DeploymentStatus deploymentStatus, ApiKey apiKey, Exception exception) {
        this.policyStore.store(policyDefinition);
        PolicyDeploymentStatus status = new PolicyDeploymentStatus(new Policy(null, policyDefinition, null), deploymentStatus);
        DeploymentExceptionHandler deploymentExceptionHandler = new DeploymentExceptionHandler(this.policyStore);
        this.apiService.get(apiKey).ifPresent(api -> deploymentExceptionHandler.handle(policyDefinition, api.getImplementation(), exception));
        this.policyDeploymentTracker.policyDeployed(apiKey, status);
    }
}

