/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies;

import static java.util.Collections.singletonList;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.HttpResourcePointcut;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;

import java.util.List;
import java.util.Map;

public class OfflinePolicyDefinition extends PolicyDefinition {

  private static final long serialVersionUID = 5560411303772713353L;

  public OfflinePolicyDefinition(String id, PolicyTemplateKey templateKey, ApiKey apiKey,
                                 List<HttpResourcePointcut> httpResourcePointcuts,
                                 int order, Map<String, Object> configurationData) {
    this(id, templateKey, singletonList(apiKey), httpResourcePointcuts, order, new PolicyConfiguration(configurationData));
  }

  public OfflinePolicyDefinition(String id, PolicyTemplateKey templateKey, ApiKey apiKey,
                                 List<HttpResourcePointcut> httpResourcePointcuts, int order,
                                 PolicyConfiguration configurationData) {
    super(id, templateKey, apiKey, httpResourcePointcuts, order, configurationData);
  }

  public OfflinePolicyDefinition(String id, PolicyTemplateKey templateKey, List<ApiKey> apiKeys,
                                 List<HttpResourcePointcut> httpResourcePointcuts, int order,
                                 PolicyConfiguration configurationData) {
    super(id, templateKey, apiKeys, httpResourcePointcuts, order, configurationData);
  }

  public OfflinePolicyDefinition(PolicyDefinition policyDefinition, PolicyConfiguration configurationData) {
    super(policyDefinition, configurationData);
  }

  @Override
  public String getName() {
    return getId();
  }

  @Override
  public boolean isOnline() {
    return false;
  }

}
