/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.deployment;

import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.policies.Policy;

/**
 * Provides the functionality to deploy and undeploy policies to applications
 */
public interface PolicyDeployer {

  /**
   * Resolves the template, stores it an deploys the policy to the specified API implementation.
   *
   * @param policy policy to deploy
   * @param api where to deploy
   */
  void deploy(Policy policy, Api api);

  /**
   * Undeploys the given policy from the specified API implementation.
   * 
   * @param policyName name of the policy to undeploy
   * @param api from where to undeploy
   * @return true if the policy was undeployed, false otherwise
   */
  boolean undeploy(String policyName, Api api);
}
