/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.serialization;

import static java.util.stream.Collectors.toList;

import com.mulesoft.mule.runtime.gw.api.policy.HttpResourcePointcut;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

public class PointcutsDto {

  @JsonProperty("resources")
  private List<HttpResourcePointcutDTO> resources;

  public static PointcutsDto from(List<HttpResourcePointcut> httpResourcePointcuts) {
    List<HttpResourcePointcutDTO> resourcesDTO = null;

    if (httpResourcePointcuts != null && !httpResourcePointcuts.isEmpty()) {
      resourcesDTO = httpResourcePointcuts.stream()
          .map(resourcePointcut -> new HttpResourcePointcutDTO(resourcePointcut.getPath(), resourcePointcut.getMethod()))
          .collect(toList());
    }

    PointcutsDto pointcutsDto = new PointcutsDto();
    pointcutsDto.resources = resourcesDTO;
    return pointcutsDto;
  }

  public List<HttpResourcePointcutDTO> getResources() {
    return resources;
  }

  public static class HttpResourcePointcutDTO {

    private String path;
    private String method;

    public HttpResourcePointcutDTO() {}

    public HttpResourcePointcutDTO(String path, String method) {
      this.path = path;
      this.method = method;
    }

    public String getPath() {
      return path;
    }

    public String getMethod() {
      return method;
    }
  }
}
