/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.service;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import com.mulesoft.mule.runtime.gw.policies.deployment.DefaultPolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.deployment.PolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.notification.PolicyNotificationListenerSuppliers;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStore;

public class DefaultPolicyDeploymentService implements PolicyDeploymentService {

  private final ApiService apiService;
  private final PolicyDeployer policyDeployer;
  private final PolicyDeploymentTracker policyDeploymentTracker;

  public DefaultPolicyDeploymentService(ApiService apiService,
                                        PolicyNotificationListenerSuppliers notificationListenerManager,
                                        PolicyDeploymentTracker policyDeploymentTracker,
                                        PolicyStore policyStore) {
    this.apiService = apiService;
    this.policyDeploymentTracker = policyDeploymentTracker;
    this.policyDeployer = new DefaultPolicyDeployer(this.policyDeploymentTracker,
                                                    policyStore,
                                                    notificationListenerManager);
  }

  @Override
  public void newPolicy(Policy policy) {
    policy.getPolicyDefinition().getApiKeys()
        .forEach(apiKey -> apiService.get(apiKey)
            .ifPresent(api -> policyDeployer.deploy(policy, api)));
  }

  @Override
  public void newPolicyForApi(Policy policy, ApiKey apiKey) {
    PolicyDefinition policyDefinition = policy.getPolicyDefinition();
    if (policyDefinition.getApiKeys().contains(apiKey)) {
      apiService.get(apiKey).ifPresent(api -> policyDeployer.deploy(policy, api));
    }
  }

  @Override
  public void updatePolicy(Policy policy) {
    removePolicy(policy);
    newPolicy(policy);
  }

  @Override
  public void removePolicy(Policy policy) {
    PolicyDefinition policyDefinition = policy.getPolicyDefinition();
    policyDefinition.getApiKeys()
        .forEach(apiKey -> apiService.get(apiKey)
            .ifPresent(api -> policyDeployer.undeploy(policyDefinition.getName(), api)));
  }

  @Override
  public void removePolicy(String policyName) {
    policyDeploymentTracker.findByName(policyName).ifPresent(this::removePolicy);
  }

}
