/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.template.exception;

import static com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus.DeploymentStatus.DEPLOYMENT_FAILED;

import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;

/**
 * Exception thrown when an error occurs while resolving the variables values in a policy template
 */
public class PolicyTemplateResolverException extends PolicyTemplateException {

  private static final long serialVersionUID = 5777309630021994432L;

  public PolicyTemplateResolverException(String message, Exception exception) {
    super(message, exception);
  }

  @Override
  public PolicyDeploymentStatus.DeploymentStatus status() {
    return DEPLOYMENT_FAILED;
  }
}
