/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.lifecycle;


import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.gatekeeper.status.GatekeeperStatusTracker;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import com.mulesoft.mule.runtime.gw.policies.deployment.PolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.BlockingGateKeeper;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.FlexibleGateKeeper;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.GateKeeper;
import com.mulesoft.mule.runtime.gw.policies.template.PolicyTemplate;
import com.mulesoft.mule.runtime.gw.reflection.VariableOverride;

import java.lang.reflect.Method;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;


@RunWith(MockitoJUnitRunner.class)
public class GatekeeperPolicyIdTestCase {

  private static final String RESOLVED_TEMPLATE = "resolvedTemplate";

  @Captor
  private ArgumentCaptor<PolicyDefinition> captor;

  private Long apiId = 101L;
  private ApiKey apiKey = mock(ApiKey.class);
  private ApiImplementation apiImplementation = mock(ApiImplementation.class);
  private Api api = mock(Api.class);
  private PolicyDeployer policyDeployer = mock(PolicyDeployer.class);
  private ApiService apiService = mock(ApiService.class);
  private String policyId = "gatekeeper-" + apiId;

  @Mock
  private PolicyTemplate policyTemplate;

  @Mock
  private PolicyFactory policyFactory;

  private Policy policy;

  private GateKeeper gateKeeper;

  @Before
  public void setup() {
    gateKeeper = new FlexibleGateKeeper(apiService, policyFactory);

    GatekeeperStatusTracker status = mock(GatekeeperStatusTracker.class);
    when(apiKey.id()).thenReturn(apiId);
    when(apiImplementation.gatekeeperStatus()).thenReturn(status);
    when(status.isBlocked()).thenReturn(false);
    when(api.getImplementation()).thenReturn(apiImplementation);
    when(api.getKey()).thenReturn(apiKey);
    VariableOverride.overrideVariable("policyDeployer").in(gateKeeper).with(policyDeployer);

    PolicyDefinition policyDefinition = captor.capture();
    policy = new Policy(policyTemplate, policyDefinition, RESOLVED_TEMPLATE);
    when(policyFactory.createFromPolicyDefinition(policyDefinition)).thenReturn(policy);
  }

  @Test
  public void blockApi() throws Exception {
    execute("doBlockApi");
    verify(policyDeployer).deploy(policy, api);
    assertThat(captor.getValue().getId(), is(policyId));
  }

  @Test
  public void unblockApi() throws Exception {
    execute("unblockApi");
    verify(policyDeployer).undeploy(policyId, api);
  }

  private void execute(String method) throws Exception {
    Method m = BlockingGateKeeper.class.getDeclaredMethod(method, Api.class);
    m.setAccessible(true);
    m.invoke(gateKeeper, api);
  }

}
