/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.lifecycle;

import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.deployment.model.api.application.Application;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.model.gatekeeper.status.DefaultGatekeeperStatusTracker;
import com.mulesoft.mule.runtime.gw.model.gatekeeper.status.GatekeeperStatusTracker;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.HdpApisHealthCheckListener;

import java.util.List;
import java.util.Optional;

import org.junit.Before;
import org.junit.Test;

public class HdpApiHealthCheckListenerTestCase {

  private Long apiId = 101L;
  private Application application = mock(Application.class);
  private Flow flow = mock(Flow.class);
  private ApiKey apiKey = new ApiKey(apiId);
  private PolicySet policySet = mock(PolicySet.class);
  private List<PolicyDeploymentStatus> policyDeploymentStatus = mock(List.class);
  private Api api = mock(Api.class);
  private ApiService apiService = mock(ApiService.class);
  private HdpApisHealthCheckListener hdpApisHealthCheckListener = new HdpApisHealthCheckListener(apiService);
  private ApiImplementation apiImplementation;

  @Before
  public void setup() {
    apiImplementation =
        new ApiImplementation(apiKey, application, flow, "some", false);
    apiImplementation.gatekeeperStatus().blocked();
    when(api.getKey()).thenReturn(apiKey);
    when(api.getImplementation()).thenReturn(apiImplementation);
    when(apiService.get(apiKey)).thenReturn(Optional.of(api));
  }

  @Test
  public void blockApi() {
    assertThat(api.getImplementation().gatekeeperStatus().isBlocked(), is(true));
  }

  @Test
  public void unblockApi() {
    hdpApisHealthCheckListener.onPolicySetDeploymentCompleted(apiKey, policySet, policyDeploymentStatus);
    assertThat(api.getImplementation().gatekeeperStatus().isBlocked(), is(false));
  }

  @Test
  public void doNotUnblockMoreThanOnce() {
    ApiImplementation impl = mock(ApiImplementation.class);
    when(impl.isHdp()).thenReturn(true);

    GatekeeperStatusTracker status = mock(GatekeeperStatusTracker.class);
    when(impl.gatekeeperStatus()).thenReturn(status);
    when(status.isBlocked()).thenReturn(true).thenReturn(false);
    when(status.shouldUnblock()).thenReturn(true);
    when(api.getImplementation()).thenReturn(impl);
    hdpApisHealthCheckListener.onPolicySetDeploymentCompleted(apiKey, policySet, policyDeploymentStatus);
    hdpApisHealthCheckListener.onPolicySetDeploymentCompleted(apiKey, policySet, policyDeploymentStatus);
    verify(api.getImplementation().gatekeeperStatus(), times(1)).unblocked();
  }
}
