/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.encryption;

import com.google.common.collect.ImmutableMap;
import com.mulesoft.mule.runtime.gw.internal.encryption.GatewayEncryptionException;
import com.mulesoft.mule.runtime.gw.internal.encryption.RuntimeEncrypter;
import com.mulesoft.mule.runtime.gw.internal.encryption.RuntimeEncrypterFactory;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicyProperty;
import com.mulesoft.mule.runtime.gw.model.PolicySpecification;
import com.mulesoft.mule.runtime.gw.policies.encryption.DefaultPolicyConfigurationEncrypter;
import com.mulesoft.mule.runtime.gw.policies.encryption.PolicyConfigurationEncrypter;
import com.mulesoft.mule.runtime.gw.policies.encryption.PolicyConfigurationEncryptionResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

@RunWith(value=Parameterized.class)
public class FullPolicyConfigurationEncrypterTestCase
extends AbstractMuleTestCase {
    private static final String KEY = "Key";
    private static final String KEY_2 = "Key_2";
    private static final String KEY_LIST_STRING = "List_String";
    private static final String KEY_BOOLEAN = "Key_Boolean";
    private static final String KEY_KEYVALUE = "Keyvalue";
    private static final String KEY_KEYVALUE_2 = "Keyvalue_2";
    private static final String KEY_KEYVALUE_3 = "Keyvalue_3";
    private static final String KEY_LIST_KEYVALUES = "List_Keyvalues";
    private static final String KEY_NOT_DEFINED = "KeyNotDefinedInYaml";
    private static final String KEY_NULL_VALUE = "KeyWithNullValue";
    private static final String ENCRYPTION_KEY = "GatewayTeamKey00";
    private static final String ENCRYPTED_VALUE = "![z8p1poC0yyjUoTNzZhS2Xw==]";
    private static final String ENCRYPTED_VALUE_2 = "![dz3YF4DaHoJNwbdLD8Uzxg==]";
    private static final String ENCRYPTED_TEMPLATE_PLACEHOLDER = "${secure::%s}";
    private static final String SIMPLE_KEY = "mapKey";
    private static final String SIMPLE_KEY_2 = "mapKey2";
    private static final String SIMPLE_VALUE = "Test Value";
    private static final String SIMPLE_VALUE_2 = "Test Value2";
    private static final String ESCAPED_VALUE = "&quot;__&lt;Guns_&amp;&amp;_Roses&#39;&gt;__&quot;\"";
    private static final String ESCAPED_ENCRYTED_VALUE = "![1/qRVKESF3Y1oPkhwYLZ4fJmb4oJR5ZG4TUDLKkj9VM=]";
    private static final String HTML_ENCODED_EXPRESSION = "#[attributes.headers[&#39;client_secret&#39;]]";
    private static final String HTML_ENCODED_EXPRESSION_ENCRYPTED = "![bA9b4+qkgeX/zCyvDg58JSdwl/bKR9b6k2rgV+eY3ddpqh2SMAn3ZUc8fZQDyD3O]";
    private final PolicySpecification policySpecification;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public SystemProperty encryptionKey = new SystemProperty("anypoint.platform.encryption_key", "GatewayTeamKey00");
    private PolicyConfigurationEncrypter policyConfigurationEncrypter;

    @Parameterized.Parameters
    public static Collection<Object[]> testConfigurationData() {
        return Arrays.asList({FullPolicyConfigurationEncrypterTestCase.sensitiveSpecification()}, {FullPolicyConfigurationEncrypterTestCase.nonSensitiveSpecification()});
    }

    public FullPolicyConfigurationEncrypterTestCase(PolicySpecification policySpecification) {
        this.policySpecification = policySpecification;
    }

    @Before
    public void setUp() {
        RuntimeEncrypter runtimeEncrypter = RuntimeEncrypterFactory.createDefaultRuntimeEncrypter();
        this.policyConfigurationEncrypter = new DefaultPolicyConfigurationEncrypter(runtimeEncrypter, false);
    }

    @Test
    public void encryptString() {
        PolicyConfigurationEncryptionResult result = this.policyConfigurationEncrypter.encryptConfiguration(this.policyDefinition((Map<String, Object>)ImmutableMap.of((Object)KEY, (Object)SIMPLE_VALUE, (Object)KEY_2, (Object)ESCAPED_VALUE)), this.policySpecification);
        MatcherAssert.assertThat((Object)result.getConfigurationProperties().isEncrypted(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(result.getConfigurationProperties().getConfiguration().get(KEY), (Matcher)CoreMatchers.is((Object)ENCRYPTED_VALUE));
        MatcherAssert.assertThat(result.getConfigurationProperties().getConfiguration().get(KEY_2), (Matcher)CoreMatchers.is((Object)ESCAPED_ENCRYTED_VALUE));
        MatcherAssert.assertThat(result.getConfigFileProperties().get(KEY), (Matcher)CoreMatchers.is((Object)ENCRYPTED_VALUE));
        MatcherAssert.assertThat(result.getConfigFileProperties().get(KEY_2), (Matcher)CoreMatchers.is((Object)ESCAPED_ENCRYTED_VALUE));
        MatcherAssert.assertThat(result.getTemplatePlaceholders().get(KEY), (Matcher)CoreMatchers.is((Object)this.encryptedTemplatePlaceholder(KEY)));
        MatcherAssert.assertThat(result.getTemplatePlaceholders().get(KEY_2), (Matcher)CoreMatchers.is((Object)this.encryptedTemplatePlaceholder(KEY_2)));
    }

    @Test
    public void encryptingExpressionWithHTMLEncodedCharacters() {
        PolicyConfigurationEncryptionResult result = this.policyConfigurationEncrypter.encryptConfiguration(this.policyDefinition((Map<String, Object>)ImmutableMap.of((Object)KEY, (Object)HTML_ENCODED_EXPRESSION)), this.policySpecification);
        MatcherAssert.assertThat((Object)result.getConfigurationProperties().isEncrypted(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(result.getConfigurationProperties().getConfiguration().get(KEY), (Matcher)CoreMatchers.is((Object)HTML_ENCODED_EXPRESSION_ENCRYPTED));
        MatcherAssert.assertThat(result.getTemplatePlaceholders().get(KEY), (Matcher)CoreMatchers.is((Object)this.encryptedTemplatePlaceholder(KEY)));
        MatcherAssert.assertThat(result.getConfigFileProperties().get(KEY), (Matcher)CoreMatchers.is((Object)HTML_ENCODED_EXPRESSION_ENCRYPTED));
    }

    @Test
    public void encryptBoolean() {
        PolicyConfigurationEncryptionResult result = this.policyConfigurationEncrypter.encryptConfiguration(this.policyDefinition((Map<String, Object>)ImmutableMap.of((Object)KEY_BOOLEAN, (Object)true)), this.policySpecification);
        MatcherAssert.assertThat((Object)result.getConfigurationProperties().isEncrypted(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat(result.getConfigurationProperties().getConfiguration().get(KEY_BOOLEAN), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(result.getConfigFileProperties().get(KEY_BOOLEAN), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat(result.getTemplatePlaceholders().get(KEY_BOOLEAN), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void encryptNotDefinedKey() {
        PolicyConfigurationEncryptionResult result = this.policyConfigurationEncrypter.encryptConfiguration(this.policyDefinition((Map<String, Object>)ImmutableMap.of((Object)KEY_NOT_DEFINED, (Object)SIMPLE_VALUE)), this.policySpecification);
        MatcherAssert.assertThat((Object)result.getConfigurationProperties().isEncrypted(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat(result.getConfigurationProperties().getConfiguration().get(KEY_NOT_DEFINED), (Matcher)CoreMatchers.is((Object)SIMPLE_VALUE));
        MatcherAssert.assertThat(result.getConfigFileProperties().get(KEY_NOT_DEFINED), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat(result.getTemplatePlaceholders().get(KEY_NOT_DEFINED), (Matcher)CoreMatchers.is((Object)SIMPLE_VALUE));
    }

    @Test
    public void encryptListOfStrings() {
        PolicyConfigurationEncryptionResult result = this.policyConfigurationEncrypter.encryptConfiguration(this.policyDefinition((Map<String, Object>)ImmutableMap.of((Object)KEY_LIST_STRING, Arrays.asList(SIMPLE_VALUE, SIMPLE_VALUE_2, ESCAPED_VALUE))), this.policySpecification);
        MatcherAssert.assertThat((Object)result.getConfigurationProperties().isEncrypted(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((List)result.getConfigurationProperties().getConfiguration().get(KEY_LIST_STRING)), (Matcher)Matchers.contains((Object[])new String[]{ENCRYPTED_VALUE, ENCRYPTED_VALUE_2, ESCAPED_ENCRYTED_VALUE}));
        MatcherAssert.assertThat((Object)((List)result.getTemplatePlaceholders().get(KEY_LIST_STRING)), (Matcher)Matchers.contains((Object[])new String[]{this.encryptedTemplatePlaceholder("List_String.0"), this.encryptedTemplatePlaceholder("List_String.1"), this.encryptedTemplatePlaceholder("List_String.2")}));
        MatcherAssert.assertThat(((Map)result.getConfigFileProperties().get(KEY_LIST_STRING)).get("0"), (Matcher)CoreMatchers.is((Object)ENCRYPTED_VALUE));
        MatcherAssert.assertThat(((Map)result.getConfigFileProperties().get(KEY_LIST_STRING)).get("1"), (Matcher)CoreMatchers.is((Object)ENCRYPTED_VALUE_2));
        MatcherAssert.assertThat(((Map)result.getConfigFileProperties().get(KEY_LIST_STRING)).get("2"), (Matcher)CoreMatchers.is((Object)ESCAPED_ENCRYTED_VALUE));
    }

    @Test
    public void encryptKeyvalue() {
        ImmutableMap propertyMap = ImmutableMap.of((Object)"key", (Object)SIMPLE_KEY, (Object)"value", (Object)SIMPLE_VALUE);
        ImmutableMap propertyMap2 = ImmutableMap.of((Object)"key", (Object)SIMPLE_KEY, (Object)"value", (Object)ESCAPED_VALUE);
        HashMap<String, String> propertyMap3 = new HashMap<String, String>();
        propertyMap3.put("key", SIMPLE_KEY);
        propertyMap3.put("value", null);
        PolicyConfigurationEncryptionResult result = this.policyConfigurationEncrypter.encryptConfiguration(this.policyDefinition((Map<String, Object>)ImmutableMap.of((Object)KEY_KEYVALUE, (Object)propertyMap, (Object)KEY_KEYVALUE_2, (Object)propertyMap2, (Object)KEY_KEYVALUE_3, propertyMap3)), this.policySpecification);
        MatcherAssert.assertThat((Object)result.getConfigurationProperties().isEncrypted(), (Matcher)CoreMatchers.is((Object)true));
        this.assertKeyValue((Map)result.getConfigurationProperties().getConfiguration().get(KEY_KEYVALUE), SIMPLE_KEY, ENCRYPTED_VALUE);
        this.assertKeyValue((Map)result.getConfigurationProperties().getConfiguration().get(KEY_KEYVALUE_2), SIMPLE_KEY, ESCAPED_ENCRYTED_VALUE);
        this.assertKeyValue((Map)result.getTemplatePlaceholders().get(KEY_KEYVALUE), SIMPLE_KEY, this.encryptedTemplatePlaceholder(KEY_KEYVALUE, SIMPLE_KEY));
        this.assertKeyValue((Map)result.getTemplatePlaceholders().get(KEY_KEYVALUE_2), SIMPLE_KEY, this.encryptedTemplatePlaceholder(KEY_KEYVALUE_2, SIMPLE_KEY));
        this.assertKeyValue((Map)result.getConfigFileProperties().get(KEY_KEYVALUE), SIMPLE_KEY, ENCRYPTED_VALUE);
        this.assertKeyValue((Map)result.getConfigFileProperties().get(KEY_KEYVALUE_2), SIMPLE_KEY, ESCAPED_ENCRYTED_VALUE);
    }

    @Test
    public void encryptListOfKeyvalues() {
        ImmutableMap propertyMap = ImmutableMap.of((Object)"key", (Object)SIMPLE_KEY, (Object)"value", (Object)SIMPLE_VALUE);
        ImmutableMap propertyMap2 = ImmutableMap.of((Object)"key", (Object)SIMPLE_KEY_2, (Object)"value", (Object)ESCAPED_VALUE);
        PolicyConfigurationEncryptionResult result = this.policyConfigurationEncrypter.encryptConfiguration(this.policyDefinition((Map<String, Object>)ImmutableMap.of((Object)KEY_LIST_KEYVALUES, Arrays.asList(propertyMap, propertyMap2))), this.policySpecification);
        MatcherAssert.assertThat((Object)result.getConfigurationProperties().isEncrypted(), (Matcher)CoreMatchers.is((Object)true));
        this.assertKeyValue((Map)((List)result.getConfigurationProperties().getConfiguration().get(KEY_LIST_KEYVALUES)).get(0), SIMPLE_KEY_2, ESCAPED_ENCRYTED_VALUE);
        this.assertKeyValue((Map)((List)result.getConfigurationProperties().getConfiguration().get(KEY_LIST_KEYVALUES)).get(1), SIMPLE_KEY, ENCRYPTED_VALUE);
        this.assertKeyValue((Map)((List)result.getTemplatePlaceholders().get(KEY_LIST_KEYVALUES)).get(0), SIMPLE_KEY_2, this.encryptedTemplatePlaceholder(KEY_LIST_KEYVALUES, SIMPLE_KEY_2));
        this.assertKeyValue((Map)((List)result.getTemplatePlaceholders().get(KEY_LIST_KEYVALUES)).get(1), SIMPLE_KEY, this.encryptedTemplatePlaceholder(KEY_LIST_KEYVALUES, SIMPLE_KEY));
        MatcherAssert.assertThat(((Map)result.getConfigFileProperties().get(KEY_LIST_KEYVALUES)).get(SIMPLE_KEY), (Matcher)CoreMatchers.is((Object)ENCRYPTED_VALUE));
        MatcherAssert.assertThat(((Map)result.getConfigFileProperties().get(KEY_LIST_KEYVALUES)).get(SIMPLE_KEY_2), (Matcher)CoreMatchers.is((Object)ESCAPED_ENCRYTED_VALUE));
    }

    @Test
    public void encryptNullValue() {
        HashMap<String, Object> nullConfigValue = new HashMap<String, Object>();
        nullConfigValue.put(KEY_NULL_VALUE, null);
        PolicyConfigurationEncryptionResult result = this.policyConfigurationEncrypter.encryptConfiguration(this.policyDefinition(nullConfigValue), this.policySpecification);
        MatcherAssert.assertThat((Object)result.getConfigurationProperties().getConfiguration().containsKey(KEY_NULL_VALUE), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(result.getConfigurationProperties().getConfiguration().get(KEY_NULL_VALUE), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)result.getTemplatePlaceholders().containsKey(KEY_NULL_VALUE), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(result.getTemplatePlaceholders().get(KEY_NULL_VALUE), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)result.getConfigFileProperties().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void encrypterFailsToEncrypt() {
        RuntimeEncrypter invalidEncrypter = (RuntimeEncrypter)Mockito.mock(RuntimeEncrypter.class);
        Mockito.when((Object)invalidEncrypter.encrypt((String)org.mockito.Matchers.any())).thenThrow(new Throwable[]{new GatewayEncryptionException("")});
        this.policyConfigurationEncrypter = new DefaultPolicyConfigurationEncrypter(invalidEncrypter, false);
        this.expectedException.expect(GatewayEncryptionException.class);
        this.policyConfigurationEncrypter.encryptConfiguration(this.policyDefinition((Map<String, Object>)ImmutableMap.of((Object)KEY, (Object)SIMPLE_VALUE)), this.policySpecification);
    }

    private PolicyDefinition policyDefinition(Map<String, Object> configData) {
        PolicyDefinition policyDefinition = (PolicyDefinition)Mockito.mock(PolicyDefinition.class);
        Mockito.when((Object)policyDefinition.getConfigurationData()).thenReturn((Object)new PolicyConfiguration(configData));
        return policyDefinition;
    }

    private static PolicySpecification sensitiveSpecification() {
        return FullPolicyConfigurationEncrypterTestCase.mockSpecification(true);
    }

    private static PolicySpecification nonSensitiveSpecification() {
        return FullPolicyConfigurationEncrypterTestCase.mockSpecification(false);
    }

    private static PolicySpecification mockSpecification(boolean sensitive) {
        PolicySpecification policySpecification = (PolicySpecification)Mockito.mock(PolicySpecification.class);
        Mockito.when((Object)policySpecification.getConfiguration()).thenReturn(FullPolicyConfigurationEncrypterTestCase.buildMockedPolicyProperties(sensitive));
        Mockito.when((Object)policySpecification.isValid()).thenReturn((Object)true);
        return policySpecification;
    }

    private static List<PolicyProperty> buildMockedPolicyProperties(boolean sensitive) {
        PolicyProperty policyProperty1 = new PolicyProperty();
        policyProperty1.setPropertyName(KEY);
        policyProperty1.setSensitive(sensitive);
        policyProperty1.setType("string");
        policyProperty1.setAllowMultiple(false);
        PolicyProperty policyProperty2 = new PolicyProperty();
        policyProperty2.setPropertyName(KEY_2);
        policyProperty2.setSensitive(sensitive);
        policyProperty2.setType("string");
        policyProperty2.setAllowMultiple(false);
        PolicyProperty policyProperty3 = new PolicyProperty();
        policyProperty3.setPropertyName(KEY_BOOLEAN);
        policyProperty3.setSensitive(sensitive);
        policyProperty3.setType("boolean");
        policyProperty3.setAllowMultiple(false);
        PolicyProperty policyProperty4 = new PolicyProperty();
        policyProperty4.setPropertyName(KEY_KEYVALUE);
        policyProperty4.setSensitive(sensitive);
        policyProperty4.setType("keyvalues");
        policyProperty4.setAllowMultiple(false);
        PolicyProperty policyProperty5 = new PolicyProperty();
        policyProperty5.setPropertyName(KEY_LIST_KEYVALUES);
        policyProperty5.setSensitive(sensitive);
        policyProperty5.setType("keyvalues");
        policyProperty5.setAllowMultiple(true);
        PolicyProperty policyProperty6 = new PolicyProperty();
        policyProperty6.setPropertyName(KEY_LIST_STRING);
        policyProperty6.setSensitive(sensitive);
        policyProperty6.setType("string");
        policyProperty6.setAllowMultiple(true);
        PolicyProperty policyProperty7 = new PolicyProperty();
        policyProperty7.setPropertyName(KEY_KEYVALUE_2);
        policyProperty7.setSensitive(sensitive);
        policyProperty7.setType("keyvalues");
        policyProperty7.setAllowMultiple(false);
        return Arrays.asList(policyProperty1, policyProperty2, policyProperty3, policyProperty4, policyProperty5, policyProperty6, policyProperty7);
    }

    private void assertKeyValue(Map<String, Object> keyvalue, String key, String value) {
        MatcherAssert.assertThat((Object)keyvalue.get("key"), (Matcher)CoreMatchers.is((Object)key));
        MatcherAssert.assertThat((Object)keyvalue.get("value"), (Matcher)CoreMatchers.is((Object)value));
    }

    private String encryptedTemplatePlaceholder(String property) {
        return String.format(ENCRYPTED_TEMPLATE_PLACEHOLDER, property);
    }

    private String encryptedTemplatePlaceholder(String property, String innerProperty) {
        return String.format(ENCRYPTED_TEMPLATE_PLACEHOLDER, property + "." + innerProperty);
    }
}

