/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.factory;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.internal.encryption.RuntimeEncrypterFactory;
import com.mulesoft.mule.runtime.gw.model.IdentityManagement;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicyProperty;
import com.mulesoft.mule.runtime.gw.model.PolicySpecification;
import com.mulesoft.mule.runtime.gw.policies.OfflinePolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import com.mulesoft.mule.runtime.gw.policies.encryption.DefaultPolicyConfigurationEncrypter;
import com.mulesoft.mule.runtime.gw.policies.encryption.PolicyConfigurationEncrypter;
import com.mulesoft.mule.runtime.gw.policies.encryption.PolicyConfigurationEncryptionResult;
import com.mulesoft.mule.runtime.gw.policies.factory.EncryptedPolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.template.PolicyTemplate;
import com.mulesoft.mule.runtime.gw.policies.template.provider.PolicyTemplateProvider;
import com.mulesoft.mule.runtime.gw.policies.template.resolver.PolicyTemplateResolver;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

@RunWith(value=MockitoJUnitRunner.class)
public class EncryptedPolicyFactoryTestCase
extends AbstractMuleTestCase {
    private static final Map<String, Object> CONFIG_DATA = ImmutableMap.of((Object)"key", (Object)"some value");
    private static final Map<String, Object> IDENTITY_MANAGEMENT_CONFIG_DATA = ImmutableMap.of((Object)"key", (Object)"some value", (Object)"identityManagementTokenUrl", (Object)"identityManagementTokenUrlValue", (Object)"identityManagementClientSecret", (Object)"u6gMLNLHDv4QRAqqzRezPqcDoohC0vMTvtKUqy5", (Object)"identityManagementClientId", (Object)"api_platform");
    private static final Map<String, Object> PLACEHOLDERS = ImmutableMap.of((Object)"key", (Object)"${secure::key}");
    private static final Map<String, Object> ENCRYPTED_PLACEHOLDERS = ImmutableMap.of((Object)"encrypted", (Object)true, (Object)"key", (Object)"${secure::key}");
    private static final Map<String, Object> ENCRYPTED_IDENTITY_MANAGEMENT_PLACEHOLDERS = ImmutableMap.of((Object)"encrypted", (Object)true, (Object)"key", (Object)"${secure::key}", (Object)"identityManagementTokenUrl", (Object)"${secure::identityManagementTokenUrl}", (Object)"identityManagementClientSecret", (Object)"${secure::identityManagementClientSecret}", (Object)"identityManagementClientId", (Object)"${secure::identityManagementClientId}");
    private static final Map<String, Object> ENCRYPTED_CONFIG_DATA_MOCK = Maps.newHashMap((Map)ImmutableMap.of((Object)"key", (Object)"encryptedValue"));
    private static final Map<String, Object> ENCRYPTED_CONFIG_DATA = Maps.newHashMap((Map)ImmutableMap.of((Object)"encrypted", (Object)true, (Object)"key", (Object)"![cxDrfb5eezub4FgbvbHyHg==]"));
    private static final Map<String, Object> ENCRYPTED_IDENTITY_MANAGEMENT_CONFIG_DATA = Maps.newHashMap((Map)ImmutableMap.of((Object)"encrypted", (Object)true, (Object)"key", (Object)"![cxDrfb5eezub4FgbvbHyHg==]", (Object)"identityManagementTokenUrl", (Object)"![rQ1yMhp8i/g3ZUD+Ojnym4HaYt1AMEi1DFEcBeU9+wQ=]", (Object)"identityManagementClientSecret", (Object)"![7PzjHgPi/HLFgoJkamHv4kz8AcZhTah3GA30HfMftqlqvtSdq1pMgb7yD6fSw/iL]", (Object)"identityManagementClientId", (Object)"![fHLAAKD9KfOFL0ylTUZmww==]"));
    private PolicyFactory policyFactory;
    @Mock
    private PolicyConfigurationEncrypter encrypter;
    @Mock
    private PolicySpecification policySpecification;
    private PolicyTemplate template;
    @Mock
    private PolicyTemplateResolver templateResolver;
    @Mock
    private PolicyTemplateProvider templateProvider;
    private String resolvedTemplate = "resolvedTemplate";
    private String resolvedNotEncryptedTemplate = "resolvedNotEncryptedTemplate";
    private static final String ENCRYPTION_KEY = "GatewayTeamKey00";
    @Rule
    public SystemProperty encryptionKey = new SystemProperty("anypoint.platform.encryption_key", "GatewayTeamKey00");

    @Before
    public void setUp() {
        this.template = new PolicyTemplate(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, (File)Mockito.mock(File.class), this.policySpecification, new PolicyTemplateDescriptor(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getName()));
        Mockito.when((Object)this.templateProvider.provide((PolicyTemplateKey)org.mockito.Matchers.any())).thenReturn((Object)this.template);
        Mockito.when((Object)this.templateResolver.resolve(this.template, PLACEHOLDERS)).thenReturn((Object)this.resolvedTemplate);
        Mockito.when((Object)this.templateResolver.resolve(this.template, ENCRYPTED_PLACEHOLDERS)).thenReturn((Object)this.resolvedTemplate);
        Mockito.when((Object)this.templateResolver.resolve(this.template, ENCRYPTED_IDENTITY_MANAGEMENT_PLACEHOLDERS)).thenReturn((Object)this.resolvedTemplate);
        Mockito.when((Object)this.templateResolver.resolve(this.template, CONFIG_DATA)).thenReturn((Object)this.resolvedNotEncryptedTemplate);
        this.policyFactory = new EncryptedPolicyFactory(this.templateResolver, this.templateProvider, this.encrypter);
    }

    @Test
    public void createPolicy() {
        PolicyDefinition policyDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 1, new PolicyConfiguration(CONFIG_DATA));
        Mockito.when((Object)this.encrypter.encryptConfiguration((PolicyDefinition)org.mockito.Matchers.eq((Object)policyDefinition), (PolicySpecification)org.mockito.Matchers.any())).thenReturn((Object)new PolicyConfigurationEncryptionResult(PLACEHOLDERS, new PolicyConfiguration(ENCRYPTED_CONFIG_DATA_MOCK), null));
        Mockito.when((Object)this.policySpecification.isEncryptionSupported()).thenReturn((Object)true);
        Policy policy = this.policyFactory.createFromPolicyDefinition(policyDefinition);
        Assert.assertThat((Object)policy.getPolicyTemplate(), (Matcher)Matchers.is((Object)this.template));
        Assert.assertThat((Object)policy.getPolicyDefinition().getId(), (Matcher)Matchers.is((Object)"policyId"));
        Assert.assertThat((Object)policy.getPolicyDefinition().getTemplateKey(), (Matcher)Matchers.is((Object)PolicyTestValuesConstants.POLICY_TEMPLATE_KEY));
        Assert.assertThat((Object)policy.getPolicyDefinition().getApiKeys(), (Matcher)Matchers.contains((Object[])new ApiKey[]{PolicyTestValuesConstants.API_KEY}));
        Assert.assertThat((Object)policy.getPolicyDefinition().getOrder(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)policy.getPolicyDefinition().getHttpResourcePointcuts(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)policy.getPolicyDefinition().isOnline(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)policy.getPolicyDefinition().getConfigurationData().getConfiguration(), (Matcher)Matchers.is(ENCRYPTED_CONFIG_DATA_MOCK));
        Assert.assertThat((Object)policy.getResolvedTemplate(), (Matcher)Matchers.is((Object)this.resolvedTemplate));
    }

    @Test
    public void createPolicyRemovingIdentityManagement() {
        PolicyDefinition policyDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 1, new PolicyConfiguration(IDENTITY_MANAGEMENT_CONFIG_DATA));
        DefaultPolicyConfigurationEncrypter policyConfigurationEncrypter = new DefaultPolicyConfigurationEncrypter(RuntimeEncrypterFactory.createDefaultRuntimeEncrypter(), false);
        Mockito.when((Object)this.policySpecification.isEncryptionSupported()).thenReturn((Object)true);
        Mockito.when((Object)this.policySpecification.isValid()).thenReturn((Object)true);
        Mockito.when((Object)this.policySpecification.getIdentityManagement()).thenReturn(Optional.empty());
        PolicyProperty policyProperty = new PolicyProperty();
        policyProperty.setType("string");
        policyProperty.setPropertyName("key");
        Mockito.when((Object)this.policySpecification.getConfiguration()).thenReturn(Arrays.asList(policyProperty));
        EncryptedPolicyFactory encryptedPolicyFactory = new EncryptedPolicyFactory(this.templateResolver, this.templateProvider, (PolicyConfigurationEncrypter)policyConfigurationEncrypter);
        Policy policy = encryptedPolicyFactory.createFromPolicyDefinition(policyDefinition);
        Assert.assertThat((Object)policy.getPolicyTemplate(), (Matcher)Matchers.is((Object)this.template));
        Assert.assertThat((Object)policy.getPolicyDefinition().getId(), (Matcher)Matchers.is((Object)"policyId"));
        Assert.assertThat((Object)policy.getPolicyDefinition().getTemplateKey(), (Matcher)Matchers.is((Object)PolicyTestValuesConstants.POLICY_TEMPLATE_KEY));
        Assert.assertThat((Object)policy.getPolicyDefinition().getApiKeys(), (Matcher)Matchers.contains((Object[])new ApiKey[]{PolicyTestValuesConstants.API_KEY}));
        Assert.assertThat((Object)policy.getPolicyDefinition().getOrder(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)policy.getPolicyDefinition().getHttpResourcePointcuts(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)policy.getPolicyDefinition().isOnline(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)policy.getPolicyDefinition().getConfigurationData().getConfiguration(), (Matcher)Matchers.is(ENCRYPTED_CONFIG_DATA));
        Assert.assertThat((Object)policy.getResolvedTemplate(), (Matcher)Matchers.is((Object)this.resolvedTemplate));
    }

    @Test
    public void createPolicyNotRemovingIdentityManagement() {
        PolicyDefinition policyDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 1, new PolicyConfiguration(IDENTITY_MANAGEMENT_CONFIG_DATA));
        DefaultPolicyConfigurationEncrypter policyConfigurationEncrypter = new DefaultPolicyConfigurationEncrypter(RuntimeEncrypterFactory.createDefaultRuntimeEncrypter(), false);
        Mockito.when((Object)this.policySpecification.isEncryptionSupported()).thenReturn((Object)true);
        Mockito.when((Object)this.policySpecification.isValid()).thenReturn((Object)true);
        Mockito.when((Object)this.policySpecification.getIdentityManagement()).thenReturn(Optional.of(Mockito.mock(IdentityManagement.class)));
        PolicyProperty policyProperty = new PolicyProperty();
        policyProperty.setType("string");
        policyProperty.setPropertyName("key");
        Mockito.when((Object)this.policySpecification.getConfiguration()).thenReturn(Arrays.asList(policyProperty));
        EncryptedPolicyFactory encryptedPolicyFactory = new EncryptedPolicyFactory(this.templateResolver, this.templateProvider, (PolicyConfigurationEncrypter)policyConfigurationEncrypter);
        Policy policy = encryptedPolicyFactory.createFromPolicyDefinition(policyDefinition);
        Assert.assertThat((Object)policy.getPolicyTemplate(), (Matcher)Matchers.is((Object)this.template));
        Assert.assertThat((Object)policy.getPolicyDefinition().getId(), (Matcher)Matchers.is((Object)"policyId"));
        Assert.assertThat((Object)policy.getPolicyDefinition().getTemplateKey(), (Matcher)Matchers.is((Object)PolicyTestValuesConstants.POLICY_TEMPLATE_KEY));
        Assert.assertThat((Object)policy.getPolicyDefinition().getApiKeys(), (Matcher)Matchers.contains((Object[])new ApiKey[]{PolicyTestValuesConstants.API_KEY}));
        Assert.assertThat((Object)policy.getPolicyDefinition().getOrder(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)policy.getPolicyDefinition().getHttpResourcePointcuts(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)policy.getPolicyDefinition().isOnline(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)policy.getPolicyDefinition().getConfigurationData().getConfiguration(), (Matcher)Matchers.is(ENCRYPTED_IDENTITY_MANAGEMENT_CONFIG_DATA));
        Assert.assertThat((Object)policy.getResolvedTemplate(), (Matcher)Matchers.is((Object)this.resolvedTemplate));
    }

    @Test
    public void createPolicyNotEncryptionEnabled() {
        PolicyDefinition policyDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 1, new PolicyConfiguration(CONFIG_DATA));
        Mockito.when((Object)this.policySpecification.isEncryptionSupported()).thenReturn((Object)false);
        Policy policy = this.policyFactory.createFromPolicyDefinition(policyDefinition);
        Assert.assertThat((Object)policy.getPolicyTemplate(), (Matcher)Matchers.is((Object)this.template));
        Assert.assertThat((Object)policy.getPolicyDefinition().getId(), (Matcher)Matchers.is((Object)"policyId"));
        Assert.assertThat((Object)policy.getPolicyDefinition().getTemplateKey(), (Matcher)Matchers.is((Object)PolicyTestValuesConstants.POLICY_TEMPLATE_KEY));
        Assert.assertThat((Object)policy.getPolicyDefinition().getApiKeys(), (Matcher)Matchers.contains((Object[])new ApiKey[]{PolicyTestValuesConstants.API_KEY}));
        Assert.assertThat((Object)policy.getPolicyDefinition().getOrder(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)policy.getPolicyDefinition().getHttpResourcePointcuts(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)policy.getPolicyDefinition().isOnline(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)policy.getPolicyDefinition().getConfigurationData().getConfiguration(), (Matcher)Matchers.is(CONFIG_DATA));
        Assert.assertThat((Object)policy.getResolvedTemplate(), (Matcher)Matchers.is((Object)this.resolvedNotEncryptedTemplate));
    }

    @Test
    public void createOfflinePolicy() {
        OfflinePolicyDefinition policyDefinition = new OfflinePolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 1, new PolicyConfiguration(CONFIG_DATA));
        Mockito.when((Object)this.encrypter.encryptConfiguration((PolicyDefinition)org.mockito.Matchers.eq((Object)policyDefinition), (PolicySpecification)org.mockito.Matchers.any())).thenReturn((Object)new PolicyConfigurationEncryptionResult(PLACEHOLDERS, new PolicyConfiguration(ENCRYPTED_CONFIG_DATA_MOCK), null));
        Mockito.when((Object)this.policySpecification.isEncryptionSupported()).thenReturn((Object)true);
        Policy policy = this.policyFactory.createFromPolicyDefinition((PolicyDefinition)policyDefinition);
        Assert.assertThat((Object)policy.getPolicyTemplate(), (Matcher)Matchers.is((Object)this.template));
        Assert.assertThat((Object)policy.getPolicyDefinition().getId(), (Matcher)Matchers.is((Object)"policyId"));
        Assert.assertThat((Object)policy.getPolicyDefinition().getTemplateKey(), (Matcher)Matchers.is((Object)PolicyTestValuesConstants.POLICY_TEMPLATE_KEY));
        Assert.assertThat((Object)policy.getPolicyDefinition().getApiKeys(), (Matcher)Matchers.contains((Object[])new ApiKey[]{PolicyTestValuesConstants.API_KEY}));
        Assert.assertThat((Object)policy.getPolicyDefinition().getOrder(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)policy.getPolicyDefinition().getHttpResourcePointcuts(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)policy.getPolicyDefinition().isOnline(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)policy.getPolicyDefinition().getConfigurationData().getConfiguration(), (Matcher)Matchers.is(ENCRYPTED_CONFIG_DATA_MOCK));
        Assert.assertThat((Object)policy.getResolvedTemplate(), (Matcher)Matchers.is((Object)this.resolvedTemplate));
    }

    @Test
    public void createOfflinePolicyNotEncryptionEnabled() {
        OfflinePolicyDefinition policyDefinition = new OfflinePolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 1, new PolicyConfiguration(CONFIG_DATA));
        Mockito.when((Object)this.policySpecification.isEncryptionSupported()).thenReturn((Object)false);
        Policy policy = this.policyFactory.createFromPolicyDefinition((PolicyDefinition)policyDefinition);
        Assert.assertThat((Object)policy.getPolicyTemplate(), (Matcher)Matchers.is((Object)this.template));
        Assert.assertThat((Object)policy.getPolicyDefinition().getId(), (Matcher)Matchers.is((Object)"policyId"));
        Assert.assertThat((Object)policy.getPolicyDefinition().getTemplateKey(), (Matcher)Matchers.is((Object)PolicyTestValuesConstants.POLICY_TEMPLATE_KEY));
        Assert.assertThat((Object)policy.getPolicyDefinition().getApiKeys(), (Matcher)Matchers.contains((Object[])new ApiKey[]{PolicyTestValuesConstants.API_KEY}));
        Assert.assertThat((Object)policy.getPolicyDefinition().getOrder(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)policy.getPolicyDefinition().getHttpResourcePointcuts(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)policy.getPolicyDefinition().isOnline(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)policy.getPolicyDefinition().getConfigurationData().getConfiguration(), (Matcher)Matchers.is(CONFIG_DATA));
        Assert.assertThat((Object)policy.getResolvedTemplate(), (Matcher)Matchers.is((Object)this.resolvedNotEncryptedTemplate));
    }
}

