/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.pointcut;

import com.google.common.collect.Sets;
import com.mulesoft.mule.runtime.gw.api.policy.HttpResourcePointcut;
import com.mulesoft.mule.runtime.gw.policies.pointcut.CompositePointcut;
import com.mulesoft.mule.runtime.gw.policies.pointcut.HttpHeaderPointcut;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.http.policy.api.SourcePolicyAwareAttributes;
import org.mule.runtime.policy.api.PolicyAwareAttributes;
import org.mule.runtime.policy.api.PolicyPointcut;

public class CompositePointcutTestCase {
    private static final PolicyPointcut TRUE = policyPointcutParameters -> true;
    private static final PolicyPointcut FALSE = policyPointcutParameters -> false;

    @Test
    public void orExpression() {
        Assert.assertTrue((boolean)CompositePointcut.or((PolicyPointcut)TRUE, (PolicyPointcut)TRUE).matches(null));
        Assert.assertTrue((boolean)CompositePointcut.or((PolicyPointcut)TRUE, (PolicyPointcut)FALSE).matches(null));
        Assert.assertTrue((boolean)CompositePointcut.or((PolicyPointcut)FALSE, (PolicyPointcut)TRUE).matches(null));
        Assert.assertFalse((boolean)CompositePointcut.or((PolicyPointcut)FALSE, (PolicyPointcut)FALSE).matches(null));
    }

    @Test
    public void andExpression() {
        Assert.assertTrue((boolean)CompositePointcut.and((PolicyPointcut)TRUE, (PolicyPointcut)TRUE).matches(null));
        Assert.assertFalse((boolean)CompositePointcut.and((PolicyPointcut)TRUE, (PolicyPointcut)FALSE).matches(null));
        Assert.assertFalse((boolean)CompositePointcut.and((PolicyPointcut)FALSE, (PolicyPointcut)TRUE).matches(null));
        Assert.assertFalse((boolean)CompositePointcut.and((PolicyPointcut)FALSE, (PolicyPointcut)FALSE).matches(null));
    }

    @Test
    public void orAndExpression() {
        Assert.assertTrue((boolean)CompositePointcut.or((PolicyPointcut)TRUE, (PolicyPointcut)CompositePointcut.and((PolicyPointcut)TRUE, (PolicyPointcut)TRUE)).matches(null));
        Assert.assertTrue((boolean)CompositePointcut.or((PolicyPointcut)TRUE, (PolicyPointcut)CompositePointcut.and((PolicyPointcut)FALSE, (PolicyPointcut)TRUE)).matches(null));
        Assert.assertTrue((boolean)CompositePointcut.or((PolicyPointcut)TRUE, (PolicyPointcut)CompositePointcut.and((PolicyPointcut)TRUE, (PolicyPointcut)FALSE)).matches(null));
        Assert.assertTrue((boolean)CompositePointcut.or((PolicyPointcut)TRUE, (PolicyPointcut)CompositePointcut.and((PolicyPointcut)FALSE, (PolicyPointcut)FALSE)).matches(null));
        Assert.assertTrue((boolean)CompositePointcut.or((PolicyPointcut)FALSE, (PolicyPointcut)CompositePointcut.and((PolicyPointcut)TRUE, (PolicyPointcut)TRUE)).matches(null));
        Assert.assertFalse((boolean)CompositePointcut.or((PolicyPointcut)FALSE, (PolicyPointcut)CompositePointcut.and((PolicyPointcut)FALSE, (PolicyPointcut)TRUE)).matches(null));
        Assert.assertFalse((boolean)CompositePointcut.or((PolicyPointcut)FALSE, (PolicyPointcut)CompositePointcut.and((PolicyPointcut)TRUE, (PolicyPointcut)FALSE)).matches(null));
        Assert.assertFalse((boolean)CompositePointcut.or((PolicyPointcut)FALSE, (PolicyPointcut)CompositePointcut.and((PolicyPointcut)FALSE, (PolicyPointcut)FALSE)).matches(null));
    }

    @Test
    public void andOrExpression() {
        Assert.assertTrue((boolean)CompositePointcut.and((PolicyPointcut)TRUE, (PolicyPointcut)CompositePointcut.or((PolicyPointcut)TRUE, (PolicyPointcut)TRUE)).matches(null));
        Assert.assertTrue((boolean)CompositePointcut.and((PolicyPointcut)TRUE, (PolicyPointcut)CompositePointcut.or((PolicyPointcut)FALSE, (PolicyPointcut)TRUE)).matches(null));
        Assert.assertTrue((boolean)CompositePointcut.and((PolicyPointcut)TRUE, (PolicyPointcut)CompositePointcut.or((PolicyPointcut)TRUE, (PolicyPointcut)FALSE)).matches(null));
        Assert.assertFalse((boolean)CompositePointcut.and((PolicyPointcut)TRUE, (PolicyPointcut)CompositePointcut.or((PolicyPointcut)FALSE, (PolicyPointcut)FALSE)).matches(null));
        Assert.assertFalse((boolean)CompositePointcut.and((PolicyPointcut)FALSE, (PolicyPointcut)CompositePointcut.or((PolicyPointcut)TRUE, (PolicyPointcut)TRUE)).matches(null));
        Assert.assertFalse((boolean)CompositePointcut.and((PolicyPointcut)FALSE, (PolicyPointcut)CompositePointcut.or((PolicyPointcut)FALSE, (PolicyPointcut)TRUE)).matches(null));
        Assert.assertFalse((boolean)CompositePointcut.and((PolicyPointcut)FALSE, (PolicyPointcut)CompositePointcut.or((PolicyPointcut)TRUE, (PolicyPointcut)FALSE)).matches(null));
        Assert.assertFalse((boolean)CompositePointcut.and((PolicyPointcut)FALSE, (PolicyPointcut)CompositePointcut.or((PolicyPointcut)FALSE, (PolicyPointcut)FALSE)).matches(null));
    }

    @Test
    public void sourcePolicyAwareAttributesMixedPointcuts() {
        HttpHeaderPointcut pc1 = new HttpHeaderPointcut("policyId", "h1", "v1");
        HttpHeaderPointcut pc2 = new HttpHeaderPointcut("policyId", "h2", "v2");
        HttpResourcePointcut pc3 = new HttpResourcePointcut("/api/.*", "GET");
        HttpResourcePointcut pc4 = new HttpResourcePointcut("/xapi/.*", "PUT");
        CompositePointcut cp = CompositePointcut.or((PolicyPointcut)pc1, (PolicyPointcut)CompositePointcut.and((PolicyPointcut)pc2, (PolicyPointcut)CompositePointcut.or((PolicyPointcut)pc3, (PolicyPointcut)CompositePointcut.and((PolicyPointcut)pc4, (PolicyPointcut)TRUE))));
        SourcePolicyAwareAttributes attributes = (SourcePolicyAwareAttributes)cp.sourcePolicyAwareAttributes();
        Assert.assertThat((Object)attributes.requires((PolicyAwareAttributes.Attribute)SourcePolicyAwareAttributes.SourceAttribute.HEADERS), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)attributes.requires((PolicyAwareAttributes.Attribute)SourcePolicyAwareAttributes.SourceAttribute.REQUEST_PATH), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)attributes.getHeaders(), (Matcher)Matchers.is((Object)Sets.newHashSet((Object[])new String[]{"h1", "h2"})));
        Assert.assertThat((Object)attributes.getRequestPathPatterns(), (Matcher)Matchers.hasSize((int)2));
        Set patternStrings = attributes.getRequestPathPatterns().stream().map(Pattern::toString).collect(Collectors.toSet());
        Assert.assertThat(patternStrings, (Matcher)Matchers.is((Object)Sets.newHashSet((Object[])new String[]{"/api/.*", "/xapi/.*"})));
    }
}

