/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.service;

import com.google.common.collect.Lists;
import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.deployment.PolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.notification.PolicyNotificationListenerSuppliers;
import com.mulesoft.mule.runtime.gw.policies.service.DefaultPolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.DefaultPolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.policies.store.DefaultPolicyStore;
import com.mulesoft.mule.runtime.gw.policies.store.EncryptedPropertiesSerializer;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStore;
import com.mulesoft.mule.runtime.gw.policies.template.PolicyTemplate;
import com.mulesoft.mule.runtime.gw.reflection.VariableOverride;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemPropertyTemporaryFolder;

@RunWith(value=MockitoJUnitRunner.class)
public class PolicyDeploymentServiceTestCase
extends AbstractMuleTestCase {
    private static final String RESOLVED_TEMPLATE = "resolvedTemplate";
    @Rule
    public SystemPropertyTemporaryFolder temporaryFolder = new SystemPropertyTemporaryFolder("mule.home");
    @Mock
    private PolicyDeployer policyDeployer;
    @Mock
    private ApiService apiService;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Api api;
    private Policy policy;
    private PolicyDefinition policyDefinition;
    private PolicyDeploymentService policyDeploymentService;
    private PolicyDeploymentTracker policyDeploymentTracker;
    @Mock
    private PolicyFactory policyFactory;
    @Mock
    private PolicyTemplate policyTemplate;

    @Before
    public void setUp() {
        Mockito.when((Object)this.apiService.get(PolicyTestValuesConstants.API_KEY)).thenReturn(Optional.of(this.api));
        DefaultPolicyStore policyStore = new DefaultPolicyStore(new EncryptedPropertiesSerializer());
        this.policyDeploymentTracker = new DefaultPolicyDeploymentTracker();
        this.policyDeploymentService = new DefaultPolicyDeploymentService(this.apiService, new PolicyNotificationListenerSuppliers(), this.policyDeploymentTracker, (PolicyStore)policyStore);
        VariableOverride.overrideVariable((String)"policyDeployer").in((Object)this.policyDeploymentService).with((Object)this.policyDeployer);
        this.policyDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 1, new PolicyConfiguration(Collections.emptyMap()));
        this.policy = new Policy(this.policyTemplate, this.policyDefinition, RESOLVED_TEMPLATE);
        Mockito.when((Object)this.policyFactory.createFromPolicyDefinition(this.policyDefinition)).thenReturn((Object)this.policy);
    }

    @Test
    public void newPolicySingleApi() {
        this.policyDeploymentService.newPolicy(this.policy);
        ((PolicyDeployer)Mockito.verify((Object)this.policyDeployer)).deploy(this.policy, this.api);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeployer});
    }

    @Test
    public void newPolicyMultipleApis() {
        ApiImplementation implementation2 = (ApiImplementation)Mockito.mock(ApiImplementation.class);
        Api api2 = (Api)Mockito.mock(Api.class);
        Mockito.when((Object)api2.getImplementation()).thenReturn((Object)implementation2);
        this.policyDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, (List)Lists.newArrayList((Object[])new ApiKey[]{PolicyTestValuesConstants.API_KEY, PolicyTestValuesConstants.API_KEY_2}), null, 1, new PolicyConfiguration(Collections.emptyMap()));
        Mockito.when((Object)this.apiService.get(PolicyTestValuesConstants.API_KEY_2)).thenReturn(Optional.of(api2));
        this.policy = new Policy(this.policyTemplate, this.policyDefinition, RESOLVED_TEMPLATE);
        this.policyDeploymentService.newPolicy(this.policy);
        ((PolicyDeployer)Mockito.verify((Object)this.policyDeployer)).deploy(this.policy, this.api);
        ((PolicyDeployer)Mockito.verify((Object)this.policyDeployer)).deploy(this.policy, api2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeployer});
    }

    @Test
    public void newPolicyForSpecificApi() {
        ApiImplementation implementation2 = (ApiImplementation)Mockito.mock(ApiImplementation.class);
        Api api2 = (Api)Mockito.mock(Api.class);
        Mockito.when((Object)api2.getImplementation()).thenReturn((Object)implementation2);
        this.policyDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, (List)Lists.newArrayList((Object[])new ApiKey[]{PolicyTestValuesConstants.API_KEY, PolicyTestValuesConstants.API_KEY_2}), null, 1, new PolicyConfiguration(Collections.emptyMap()));
        Mockito.when((Object)this.apiService.get(PolicyTestValuesConstants.API_KEY_2)).thenReturn(Optional.of(api2));
        this.policy = new Policy(this.policyTemplate, this.policyDefinition, RESOLVED_TEMPLATE);
        this.policyDeploymentService.newPolicyForApi(this.policy, PolicyTestValuesConstants.API_KEY);
        ((PolicyDeployer)Mockito.verify((Object)this.policyDeployer)).deploy(this.policy, this.api);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeployer});
    }

    @Test
    public void newPolicyForSpecificNotExistingApi() {
        this.policyDeploymentService.newPolicyForApi(this.policy, PolicyTestValuesConstants.API_KEY_2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeployer});
    }

    @Test
    public void policyRemoved() {
        this.policyDeploymentService.removePolicy(this.policy);
        ((PolicyDeployer)Mockito.verify((Object)this.policyDeployer)).undeploy(this.policyDefinition.getName(), this.api);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeployer});
    }

    @Test
    public void multipleApisPolicyRemoved() {
        ApiImplementation implementation2 = (ApiImplementation)Mockito.mock(ApiImplementation.class);
        Api api2 = (Api)Mockito.mock(Api.class);
        Mockito.when((Object)api2.getImplementation()).thenReturn((Object)implementation2);
        this.policyDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, (List)Lists.newArrayList((Object[])new ApiKey[]{PolicyTestValuesConstants.API_KEY, PolicyTestValuesConstants.API_KEY_2}), null, 1, new PolicyConfiguration(Collections.emptyMap()));
        this.policy = new Policy(this.policyTemplate, this.policyDefinition, RESOLVED_TEMPLATE);
        Mockito.when((Object)this.apiService.get(PolicyTestValuesConstants.API_KEY_2)).thenReturn(Optional.of(api2));
        this.policyDeploymentService.removePolicy(this.policy);
        ((PolicyDeployer)Mockito.verify((Object)this.policyDeployer)).undeploy(this.policyDefinition.getName(), this.api);
        ((PolicyDeployer)Mockito.verify((Object)this.policyDeployer)).undeploy(this.policyDefinition.getName(), api2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeployer});
    }

    @Test
    public void policyRemovedByName() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, new PolicyDeploymentStatus(this.policy, PolicyDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS));
        this.policyDeploymentService.removePolicy(this.policyDefinition.getName());
        ((PolicyDeployer)Mockito.verify((Object)this.policyDeployer)).undeploy(this.policyDefinition.getName(), this.api);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeployer});
    }

    @Test
    public void policyUpdated() {
        PolicyDefinition updatedDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 2, new PolicyConfiguration(Collections.emptyMap()));
        Policy updatedPolicy = new Policy(this.policyTemplate, updatedDefinition, RESOLVED_TEMPLATE);
        this.policyDeploymentService.updatePolicy(updatedPolicy);
        ((PolicyDeployer)Mockito.verify((Object)this.policyDeployer)).undeploy(updatedDefinition.getName(), this.api);
        ((PolicyDeployer)Mockito.verify((Object)this.policyDeployer)).deploy(updatedPolicy, this.api);
    }
}

