/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies;

import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import java.util.Objects;

public class PolicyDeploymentStatus {
    private Policy policy;
    private PolicyDefinition policyDefinition;
    private DeploymentStatus deploymentStatus;

    public PolicyDeploymentStatus(Policy policy, DeploymentStatus applied) {
        this.policy = policy;
        this.deploymentStatus = applied;
        this.policyDefinition = policy.getPolicyDefinition();
    }

    public boolean isDeploymentSuccess() {
        return DeploymentStatus.DEPLOYMENT_SUCCESS.equals((Object)this.deploymentStatus);
    }

    public boolean isTemplateDownloadFailed() {
        return DeploymentStatus.TEMPLATE_DOWNLOAD_FAILED.equals((Object)this.deploymentStatus);
    }

    public boolean isDeploymentFailed() {
        return DeploymentStatus.DEPLOYMENT_FAILED.equals((Object)this.deploymentStatus);
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyDeploymentStatus status = (PolicyDeploymentStatus)o;
        return Objects.equals(this.policy, status.policy) && this.deploymentStatus == status.deploymentStatus;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.policy, this.deploymentStatus});
    }

    public static enum DeploymentStatus {
        DEPLOYMENT_SUCCESS,
        DEPLOYMENT_FAILED,
        TEMPLATE_DOWNLOAD_FAILED;

    }
}

