/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.deployment;

import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.deployment.DeploymentExceptionHandler;
import com.mulesoft.mule.runtime.gw.policies.deployment.PolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyParametrizationFactory;
import com.mulesoft.mule.runtime.gw.policies.notification.PolicyNotificationListenerSuppliers;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStore;
import org.mule.runtime.core.api.policy.PolicyParametrization;
import org.slf4j.Logger;

public class DefaultPolicyDeployer
implements PolicyDeployer {
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(DefaultPolicyDeployer.class);
    private final PolicyNotificationListenerSuppliers notificationListenerManager;
    private final PolicyParametrizationFactory policyParametrizationFactory = new PolicyParametrizationFactory();
    private final PolicyDeploymentTracker policyDeploymentTracker;
    private final PolicyStore policyStore;

    public DefaultPolicyDeployer(PolicyDeploymentTracker policyDeploymentTracker, PolicyStore policyStore, PolicyNotificationListenerSuppliers notificationListenerManager) {
        this.notificationListenerManager = notificationListenerManager;
        this.policyDeploymentTracker = policyDeploymentTracker;
        this.policyStore = policyStore;
    }

    @Override
    public void deploy(Policy policy, Api api) {
        PolicyDeploymentStatus status;
        ApiImplementation implementation = api.getImplementation();
        PolicyDefinition policyDefinition = policy.getPolicyDefinition();
        this.logApplyingPolicy(policyDefinition, api, implementation);
        try {
            this.policyStore.store(policy);
            PolicyParametrization policyParametrization = this.policyParametrizationFactory.create(policyDefinition, implementation, this.policyStore.getPolicyConfigFile(policyDefinition.getName()), this.policyStore.getEncryptedPropertiesFile(policyDefinition.getName()), this.notificationListenerManager.supply(implementation, policyDefinition, policy.getPolicyTemplate().getPolicySpecification()));
            implementation.addPolicy(policy.getPolicyTemplate().getTemplateDescriptor(), policyParametrization);
            status = new PolicyDeploymentStatus(policy, PolicyDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS);
            this.policyStore.cleanDeploymentFailure(policyDefinition, implementation.getApiKey());
            this.logAppliedPolicy(policyDefinition, api, implementation);
        }
        catch (Exception exception) {
            status = new PolicyDeploymentStatus(policy, PolicyDeploymentStatus.DeploymentStatus.DEPLOYMENT_FAILED);
            DeploymentExceptionHandler deploymentExceptionHandler = new DeploymentExceptionHandler(this.policyStore);
            deploymentExceptionHandler.handle(policyDefinition, implementation, exception);
        }
        this.policyDeploymentTracker.policyDeployed(implementation.getApiKey(), status);
    }

    @Override
    public boolean undeploy(String policyName, Api api) {
        String parametrizationId;
        ApiImplementation implementation = api.getImplementation();
        boolean removed = implementation.removePolicy(parametrizationId = this.policyParametrizationFactory.buildParametrizationId(policyName, implementation));
        if (removed) {
            LOGGER.info("Policy {} un-applied from {} in application {}", new Object[]{policyName, api, implementation.getArtifactName()});
        }
        this.policyDeploymentTracker.policyRemoved(implementation.getApiKey(), policyName);
        if (!this.policyDeploymentTracker.hasDeployments(policyName)) {
            this.policyStore.remove(policyName);
        }
        return removed;
    }

    private void logApplyingPolicy(PolicyDefinition policyDefinition, Api api, ApiImplementation implementation) {
        LOGGER.debug("Applying policy {} version {} to {} in application {}", new Object[]{policyDefinition.getName(), policyDefinition.getTemplateKey().getVersion(), api, implementation.getArtifactName()});
    }

    private void logAppliedPolicy(PolicyDefinition policyDefinition, Api api, ApiImplementation implementation) {
        LOGGER.info("Applied policy {} version {} to {} in application {}", new Object[]{policyDefinition.getName(), policyDefinition.getTemplateKey().getVersion(), api, implementation.getArtifactName()});
    }
}

