/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.factory;

import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicySpecification;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.template.PolicyTemplate;
import com.mulesoft.mule.runtime.gw.policies.template.provider.PolicyTemplateProvider;
import com.mulesoft.mule.runtime.gw.policies.template.resolver.PolicyTemplateResolver;
import java.util.HashMap;
import java.util.Map;

public abstract class PolicyFactoryTemplate
implements PolicyFactory {
    private static final String IDENTITY_MANAGEMENT_TOKEN_URL = "identityManagementTokenUrl";
    private static final String IDENTITY_MANAGEMENT_CLIENT_ID = "identityManagementClientId";
    private static final String IDENTITY_MANAGEMENT_CLIENT_SECRET = "identityManagementClientSecret";
    private PolicyTemplateResolver templateResolver;
    private PolicyTemplateProvider templateProvider;

    public PolicyFactoryTemplate(PolicyTemplateResolver templateResolver, PolicyTemplateProvider templateProvider) {
        this.templateResolver = templateResolver;
        this.templateProvider = templateProvider;
    }

    protected PolicyTemplate getPolicyTemplate(PolicyDefinition policyDefinition) {
        return this.templateProvider.provide(policyDefinition.getTemplateKey());
    }

    protected String resolveTemplate(PolicyTemplate policyTemplate, Map<String, Object> configurationData) {
        return this.templateResolver.resolve(policyTemplate, configurationData);
    }

    protected PolicyDefinition evaluatePolicyIdentityManagement(PolicyDefinition policyDefinition, PolicyTemplate policyTemplate) {
        if (this.shouldRemoveIdentityManagementProperty(policyDefinition.getConfigurationData().getConfiguration(), policyTemplate.getPolicySpecification())) {
            return this.getPolicyDefinitionWithoutIdentityManagement(policyDefinition);
        }
        return policyDefinition;
    }

    private boolean shouldRemoveIdentityManagementProperty(Map<String, Object> policyDefinitionConfiguration, PolicySpecification policySpecification) {
        return policySpecification.isValid() && !policySpecification.getIdentityManagement().isPresent() && this.hasIdentityManagementProperty(policyDefinitionConfiguration);
    }

    private boolean hasIdentityManagementProperty(Map<String, Object> policyDefinitionConfiguration) {
        return policyDefinitionConfiguration.get(IDENTITY_MANAGEMENT_TOKEN_URL) != null || policyDefinitionConfiguration.get(IDENTITY_MANAGEMENT_CLIENT_ID) != null || policyDefinitionConfiguration.get(IDENTITY_MANAGEMENT_CLIENT_SECRET) != null;
    }

    private PolicyDefinition getPolicyDefinitionWithoutIdentityManagement(PolicyDefinition policyDefinition) {
        HashMap policyDefinitionConfiguration = new HashMap();
        policyDefinition.getConfigurationData().getConfiguration().forEach((configKey, configValue) -> {
            if (this.fieldNameDoesNotMatchIdentityManagement((String)configKey)) {
                policyDefinitionConfiguration.putIfAbsent(configKey, configValue);
            }
        });
        return new PolicyDefinition(policyDefinition.getId(), policyDefinition.getTemplateKey(), policyDefinition.getApiKeys(), policyDefinition.getHttpResourcePointcuts(), policyDefinition.getOrder().intValue(), new PolicyConfiguration(policyDefinitionConfiguration));
    }

    private boolean fieldNameDoesNotMatchIdentityManagement(String configKey) {
        return !configKey.equals(IDENTITY_MANAGEMENT_TOKEN_URL) && !configKey.equals(IDENTITY_MANAGEMENT_CLIENT_ID) && !configKey.equals(IDENTITY_MANAGEMENT_CLIENT_SECRET);
    }
}

