/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.offline;

import com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.OfflinePolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.PolicySetDeploymentListener;
import com.mulesoft.mule.runtime.gw.policies.offline.OfflinePolicyDefinitionValidator;
import com.mulesoft.mule.runtime.gw.policies.serialization.OfflinePolicyDeserializationException;
import com.mulesoft.mule.runtime.gw.policies.serialization.PolicyDefinitionSerializer;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentService;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfflinePolicyListener
extends FileAlterationListenerAdaptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfflinePolicyListener.class);
    private final PolicyDefinitionSerializer serializer;
    private final PolicyDeploymentService policyDeploymentService;
    private final PolicyFactory policyFactory;
    private final List<PolicySetDeploymentListener> deploymentListeners = new CopyOnWriteArrayList<PolicySetDeploymentListener>();

    public OfflinePolicyListener(PolicyDeploymentService policyDeploymentService, PolicyFactory policyFactory) {
        this.policyDeploymentService = policyDeploymentService;
        this.serializer = new PolicyDefinitionSerializer();
        this.policyFactory = policyFactory;
    }

    public void onFileCreate(File definitionFile) {
        this.policyDefinition(definitionFile).ifPresent(policyDefinition -> {
            LOGGER.debug("New offline policy detected: {}", (Object)policyDefinition.getName());
            this.policyDeploymentService.newPolicy(this.policyFactory.createFromPolicyDefinition((PolicyDefinition)policyDefinition));
        });
    }

    public void onFileChange(File definitionFile) {
        this.policyDefinition(definitionFile).ifPresent(policyDefinition -> {
            LOGGER.debug("Modification detected on offline policy {}", (Object)policyDefinition.getName());
            this.policyDeploymentService.updatePolicy(this.policyFactory.createFromPolicyDefinition((PolicyDefinition)policyDefinition));
        });
    }

    public void onFileDelete(File definitionFile) {
        String policyName = this.removeFileNameExtension(definitionFile);
        LOGGER.debug("Offline policy removal detected: {}", (Object)policyName);
        this.policyDeploymentService.removePolicy(policyName);
    }

    void addPolicyDeploymentListener(PolicySetDeploymentListener listener) {
        this.deploymentListeners.add(listener);
    }

    private Optional<OfflinePolicyDefinition> policyDefinition(File definitionFile) {
        try {
            OfflinePolicyDefinitionValidator.validate(definitionFile);
            return Optional.of(this.serializer.deserializeOfflineFromFile(definitionFile));
        }
        catch (OfflinePolicyDeserializationException e) {
            LOGGER.error("Error reading offline policy definition: " + ExceptionDescriptor.errorMessage((Throwable)e));
            return Optional.empty();
        }
    }

    private String removeFileNameExtension(File file) {
        return StringUtils.substringBeforeLast((String)file.getName(), (String)".");
    }
}

