/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.offline;

import com.mulesoft.mule.runtime.gw.api.PolicyFolders;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.offline.OfflinePolicyListener;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentService;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfflinePolicyWatcher
implements Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfflinePolicyWatcher.class);
    private static final long POLLING_INTERVAL = 100L;
    private final FileAlterationListener listener;
    private final FileAlterationMonitor monitor;

    public OfflinePolicyWatcher(PolicyDeploymentService policyDeploymentService, PolicyFactory policyFactory) {
        this.listener = new OfflinePolicyListener(policyDeploymentService, policyFactory);
        this.monitor = new FileAlterationMonitor(100L);
    }

    public void initialise() {
        FileAlterationObserver observer = new FileAlterationObserver(PolicyFolders.getOfflinePoliciesFolder());
        observer.addListener(this.listener);
        this.monitor.addObserver(observer);
        this.monitor.setThreadFactory(r -> {
            Thread t = new Thread(r);
            t.setName("agw-offline-policy-watcher");
            return t;
        });
    }

    public void start() throws MuleException {
        try {
            LOGGER.debug("Policy monitor started at {}", (Object)PolicyFolders.getOfflinePoliciesFolder().getCanonicalPath());
            this.monitor.start();
        }
        catch (Exception e) {
            LOGGER.error("Error starting policies monitor. Reason: {}", (Throwable)e);
        }
    }

    public void stop() throws MuleException {
        try {
            this.monitor.stop();
        }
        catch (Exception e) {
            LOGGER.error("Error stopping monitor.", (Throwable)e);
        }
    }

    public void dispose() {
    }
}

