/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.service;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import com.mulesoft.mule.runtime.gw.policies.deployment.DefaultPolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.deployment.PolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.notification.PolicyNotificationListenerSuppliers;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStore;

public class DefaultPolicyDeploymentService
implements PolicyDeploymentService {
    private final ApiService apiService;
    private final PolicyDeployer policyDeployer;
    private final PolicyDeploymentTracker policyDeploymentTracker;

    public DefaultPolicyDeploymentService(ApiService apiService, PolicyNotificationListenerSuppliers notificationListenerManager, PolicyDeploymentTracker policyDeploymentTracker, PolicyStore policyStore) {
        this.apiService = apiService;
        this.policyDeploymentTracker = policyDeploymentTracker;
        this.policyDeployer = new DefaultPolicyDeployer(this.policyDeploymentTracker, policyStore, notificationListenerManager);
    }

    @Override
    public void newPolicy(Policy policy) {
        policy.getPolicyDefinition().getApiKeys().forEach(apiKey -> this.apiService.get(apiKey).ifPresent(api -> this.policyDeployer.deploy(policy, (Api)api)));
    }

    @Override
    public void newPolicyForApi(Policy policy, ApiKey apiKey) {
        PolicyDefinition policyDefinition = policy.getPolicyDefinition();
        if (policyDefinition.getApiKeys().contains(apiKey)) {
            this.apiService.get(apiKey).ifPresent(api -> this.policyDeployer.deploy(policy, (Api)api));
        }
    }

    @Override
    public void updatePolicy(Policy policy) {
        this.removePolicy(policy);
        this.newPolicy(policy);
    }

    @Override
    public void removePolicy(Policy policy) {
        PolicyDefinition policyDefinition = policy.getPolicyDefinition();
        policyDefinition.getApiKeys().forEach(apiKey -> this.apiService.get(apiKey).ifPresent(api -> this.policyDeployer.undeploy(policyDefinition.getName(), (Api)api)));
    }

    @Override
    public void removePolicy(String policyName) {
        this.policyDeploymentTracker.findByName(policyName).ifPresent(this::removePolicy);
    }
}

