/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.deployment;

import com.github.valfirst.slf4jtest.LoggingEvent;
import com.github.valfirst.slf4jtest.TestLogger;
import com.github.valfirst.slf4jtest.TestLoggerFactory;
import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.anypoint.tests.logger.LogMatcher;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.EmptyPolicySpecification;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.LogCleanup;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.deployment.DefaultPolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.deployment.PolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyParametrizationFactory;
import com.mulesoft.mule.runtime.gw.policies.notification.PolicyNotificationListenerSuppliers;
import com.mulesoft.mule.runtime.gw.policies.service.DefaultPolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.policies.service.DefaultTransactionalPolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentListener;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.policies.service.TransactionalPolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStore;
import com.mulesoft.mule.runtime.gw.policies.template.PolicyTemplate;
import com.mulesoft.mule.runtime.gw.policies.template.exception.PolicyTemplateResolverException;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.policy.PolicyParametrization;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.application.ApplicationPolicyManager;
import org.mule.runtime.deployment.model.api.policy.PolicyRegistrationException;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;
import org.mule.runtime.policy.api.PolicyPointcut;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemPropertyTemporaryFolder;
import uk.org.lidalia.slf4jext.Level;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultPolicyDeployerTestCase
extends AbstractMuleTestCase {
    private static final String RESOLVED_TEMPLATE = "resolvedTemplate";
    @Rule
    public SystemPropertyTemporaryFolder temporaryFolder = new SystemPropertyTemporaryFolder("mule.home");
    @Rule
    public TestRule chain = RuleChain.outerRule((TestRule)new LogCleanup());
    @Mock
    private Api api;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Application application;
    @Mock
    private ApplicationPolicyManager policyManager;
    @Mock
    private PolicyParametrizationFactory policyParametrizationFactory;
    @Mock
    private PolicyStore policyStore;
    private PolicyTemplateDescriptor templateDescriptor;
    private PolicyParametrization policyParametrization;
    private Policy policy;
    private PolicyDefinition policyDefinition;
    private DefaultPolicyDeploymentTracker policyDeploymentTracker;
    private PolicyDeploymentListener policyDeploymentListener;
    private ApiImplementation apiImplementation;
    private TransactionalPolicyDeploymentService transactionalPolicyDeployer;
    private TestLogger logger;
    private PolicyFactory policyFactory;

    @Before
    public void setUp() throws PolicyTemplateResolverException {
        PolicyTemplate template = (PolicyTemplate)Mockito.mock(PolicyTemplate.class);
        Flow flow = (Flow)Mockito.mock(Flow.class);
        this.policyDefinition = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, Collections.emptyList(), 1, new PolicyConfiguration(Collections.emptyMap()));
        this.policyFactory = (PolicyFactory)Mockito.mock(PolicyFactory.class);
        this.policy = new Policy(template, this.policyDefinition, RESOLVED_TEMPLATE);
        Mockito.when((Object)this.policyFactory.createFromPolicyDefinition(this.policyDefinition)).thenReturn((Object)this.policy);
        this.apiImplementation = new ApiImplementation(PolicyTestValuesConstants.API_KEY, this.application, flow, false);
        this.policyDeploymentTracker = new DefaultPolicyDeploymentTracker();
        this.policyDeploymentListener = (PolicyDeploymentListener)Mockito.mock(PolicyDeploymentListener.class);
        this.policyDeploymentTracker.addPolicyDeploymentListener(this.policyDeploymentListener);
        this.policyParametrization = new PolicyParametrization("id", (PolicyPointcut)Mockito.mock(PolicyPointcut.class), 1, Collections.emptyMap(), (File)Mockito.mock(File.class), Collections.emptyList());
        Mockito.when((Object)this.policyParametrizationFactory.create((Policy)ArgumentMatchers.any(), (ApiImplementation)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (Boolean)ArgumentMatchers.any(), (List)ArgumentMatchers.any())).thenReturn((Object)this.policyParametrization);
        DefaultPolicyDeployer defaultPolicyDeployer = new DefaultPolicyDeployer(this.policyStore, new PolicyNotificationListenerSuppliers(), this.policyParametrizationFactory);
        this.transactionalPolicyDeployer = new DefaultTransactionalPolicyDeploymentService((PolicyDeploymentTracker)this.policyDeploymentTracker, this.policyStore, this.policyFactory, (PolicyDeployer)defaultPolicyDeployer);
        this.templateDescriptor = new PolicyTemplateDescriptor("name");
        Mockito.when((Object)this.api.getImplementation()).thenReturn((Object)this.apiImplementation);
        Mockito.when((Object)this.api.getKey()).thenReturn((Object)PolicyTestValuesConstants.API_KEY);
        Mockito.when((Object)this.application.getPolicyManager()).thenReturn((Object)this.policyManager);
        Mockito.when((Object)template.getTemplateDescriptor()).thenReturn((Object)this.templateDescriptor);
        Mockito.when((Object)template.getPolicySpecification()).thenReturn((Object)new EmptyPolicySpecification());
        Mockito.when((Object)this.application.getArtifactClassLoader().getClassLoader()).thenReturn((Object)Thread.currentThread().getContextClassLoader());
        this.logger = TestLoggerFactory.getTestLogger(DefaultPolicyDeployer.class);
    }

    @Test
    public void deployPolicy() throws PolicyRegistrationException {
        this.transactionalPolicyDeployer.deploy(this.policyDefinition, this.api);
        Assert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY), (Matcher)IsCollectionWithSize.hasSize((int)1));
        Assert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0)).getLatestPolicyStatus().isDeploymentSuccess(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0)).getLatestPolicyStatus().isTemplateDownloadFailed(), (Matcher)Is.is((Object)false));
        ((ApplicationPolicyManager)Mockito.verify((Object)this.policyManager)).addPolicy(this.templateDescriptor, this.policyParametrization);
        ((PolicyStore)Mockito.verify((Object)this.policyStore)).store(this.policy);
        ((PolicyStore)Mockito.verify((Object)this.policyStore)).cleanDeploymentFailure(this.policyDefinition, PolicyTestValuesConstants.API_KEY);
        Assert.assertThat((String)"Log lines size does not match", (Object)this.logger.getAllLoggingEvents(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat((Object)this.logger.getAllLoggingEvents().get(0), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "Applying policy {} {} to {} in application {}", new Object[]{this.policyDefinition.getName(), String.format("version %s", this.policyDefinition.getTemplateKey().getVersion()), this.api, this.api.getImplementation().getArtifactName()})));
        Assert.assertThat((Object)this.logger.getAllLoggingEvents().get(1), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.INFO, "Applied policy {} {} to {} in application {}", new Object[]{this.policyDefinition.getName(), String.format("version %s", this.policyDefinition.getTemplateKey().getVersion()), this.api, this.api.getImplementation().getArtifactName()})));
        ((PolicyDeploymentListener)Mockito.verify((Object)this.policyDeploymentListener)).policyDeployed(PolicyTestValuesConstants.API_KEY, this.successfulStatus(this.policyDefinition));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentListener});
    }

    @Test
    public void deployPolicyFails() throws PolicyRegistrationException {
        PolicyRegistrationException exception = new PolicyRegistrationException(null, null);
        ((ApplicationPolicyManager)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)this.policyManager)).addPolicy((PolicyTemplateDescriptor)ArgumentMatchers.any(), (PolicyParametrization)ArgumentMatchers.any());
        this.transactionalPolicyDeployer.deploy(this.policyDefinition, this.api);
        Assert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY), (Matcher)IsCollectionWithSize.hasSize((int)1));
        Assert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0)).getLatestPolicyStatus().isDeploymentSuccess(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0)).getLatestPolicyStatus().isTemplateDownloadFailed(), (Matcher)Is.is((Object)false));
        ((ApplicationPolicyManager)Mockito.verify((Object)this.policyManager)).addPolicy(this.templateDescriptor, this.policyParametrization);
        ((PolicyStore)Mockito.verify((Object)this.policyStore)).store(this.policy);
        ((PolicyStore)Mockito.verify((Object)this.policyStore)).storeDeploymentFailure(this.policyDefinition, this.apiImplementation.getApiKey(), (Exception)exception);
    }

    @Test
    public void undeployPolicy() {
        PolicyDeploymentStatus status = this.successfulStatus(this.policyDefinition);
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, status);
        Mockito.reset((Object[])new PolicyDeploymentListener[]{this.policyDeploymentListener});
        Mockito.when((Object)this.policyManager.removePolicy((String)ArgumentMatchers.any())).thenReturn((Object)true);
        this.transactionalPolicyDeployer.undeploy(this.policyDefinition, this.api);
        Assert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY), (Matcher)Matchers.empty());
        ((PolicyStore)Mockito.verify((Object)this.policyStore)).remove(this.policyDefinition.getName());
        ((PolicyDeploymentListener)Mockito.verify((Object)this.policyDeploymentListener)).policyRemoved(PolicyTestValuesConstants.API_KEY, status);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentListener});
    }

    @Test
    public void undeployPolicyWithMultipleDeployments() {
        PolicyDeploymentStatus status = this.successfulStatus(this.policyDefinition);
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, status);
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY_2, status);
        Mockito.reset((Object[])new PolicyDeploymentListener[]{this.policyDeploymentListener});
        Mockito.when((Object)this.policyManager.removePolicy((String)ArgumentMatchers.any())).thenReturn((Object)true);
        this.transactionalPolicyDeployer.undeploy(this.policyDefinition, this.api);
        Assert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY), (Matcher)Matchers.empty());
        Assert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY_2), (Matcher)IsCollectionWithSize.hasSize((int)1));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.policyStore});
        ((PolicyDeploymentListener)Mockito.verify((Object)this.policyDeploymentListener)).policyRemoved(PolicyTestValuesConstants.API_KEY, status);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentListener});
    }

    @Test
    public void undeployNotDeployedPolicy() {
        this.transactionalPolicyDeployer.undeploy(this.policyDefinition, this.api);
        ((PolicyStore)Mockito.verify((Object)this.policyStore)).remove(this.policyDefinition.getName());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentListener});
    }

    private PolicyDeploymentStatus successfulStatus(PolicyDefinition definition) {
        return new PolicyDeploymentStatus(new PolicyDefinitionDeploymentStatus(definition));
    }
}

