/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.encryption;

import com.google.common.collect.ImmutableMap;
import com.mulesoft.mule.runtime.gw.internal.encryption.RuntimeEncrypter;
import com.mulesoft.mule.runtime.gw.internal.encryption.RuntimeEncrypterFactory;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicyProperty;
import com.mulesoft.mule.runtime.gw.model.PolicySpecification;
import com.mulesoft.mule.runtime.gw.policies.encryption.DefaultPolicyConfigurationEncrypter;
import com.mulesoft.mule.runtime.gw.policies.encryption.PolicyConfigurationEncrypter;
import com.mulesoft.mule.runtime.gw.policies.encryption.PolicyConfigurationEncryptionResult;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

public class SensitivePolicyConfigurationEncrypterTestCase
extends AbstractMuleTestCase {
    private static final String KEY = "Key";
    private static final String KEY_2 = "Key2";
    private static final String KEY_LIST_STRING = "List_String";
    private static final String KEY_BOOLEAN = "Key_Boolean";
    private static final String KEY_KEYVALUE = "Keyvalue";
    private static final String KEY_LIST_KEYVALUES = "List_Keyvalues";
    private static final String KEY_NOT_DEFINED = "KeyNotDefinedInYaml";
    private static final String ENCRYPTION_KEY = "GatewayTeamKey00";
    private static final String ENCRYPTED_VALUE = "![z8p1poC0yyjUoTNzZhS2Xw==]";
    private static final String ENCRYPTED_VALUE_2 = "![dz3YF4DaHoJNwbdLD8Uzxg==]";
    private static final String ENCRYPTED_TEMPLATE_PLACEHOLDER = "${secure::%s}";
    private static final String SIMPLE_KEY = "mapKey";
    private static final String SIMPLE_KEY_2 = "mapKey2";
    private static final String SIMPLE_VALUE = "Test Value";
    private static final String SIMPLE_VALUE_2 = "Test Value2";
    private static final String HTML_ENCODED_EXPRESSION = "#[attributes.headers[&#39;client_secret&#39;]]";
    private static final String EXPRESSION = "#[attributes.headers['client_secret']]";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public SystemProperty encryptionKey = new SystemProperty("anypoint.platform.encryption_key", "GatewayTeamKey00");
    private PolicyConfigurationEncrypter sensitiveOnlyEncrypter;

    @Before
    public void setUp() {
        RuntimeEncrypter runtimeEncrypter = RuntimeEncrypterFactory.createDefaultRuntimeEncrypter();
        this.sensitiveOnlyEncrypter = new DefaultPolicyConfigurationEncrypter(runtimeEncrypter, true);
    }

    @Test
    public void encryptString() {
        PolicyConfigurationEncryptionResult result = this.sensitiveOnlyEncrypter.encryptConfiguration(this.policyDefinition((Map<String, Object>)ImmutableMap.of((Object)KEY, (Object)SIMPLE_VALUE)), this.sensitiveSpecification());
        MatcherAssert.assertThat((Object)result.getConfigurationProperties().isEncrypted(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(result.getConfigurationProperties().getConfiguration().get(KEY), (Matcher)CoreMatchers.is((Object)ENCRYPTED_VALUE));
        MatcherAssert.assertThat(result.getConfigFileProperties().get(KEY), (Matcher)CoreMatchers.is((Object)ENCRYPTED_VALUE));
        MatcherAssert.assertThat(result.getTemplatePlaceholders().get(KEY), (Matcher)CoreMatchers.is((Object)this.encryptedTemplatePlaceholder(KEY)));
    }

    @Test
    public void decryptingExpressionWithHTMLEncodedCharacters() {
        PolicyConfigurationEncryptionResult result = this.sensitiveOnlyEncrypter.encryptConfiguration(this.policyDefinition((Map<String, Object>)ImmutableMap.of((Object)KEY, (Object)HTML_ENCODED_EXPRESSION)), this.nonSensitiveSpecification());
        MatcherAssert.assertThat((Object)result.getConfigurationProperties().isEncrypted(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat(result.getConfigurationProperties().getConfiguration().get(KEY), (Matcher)CoreMatchers.is((Object)EXPRESSION));
        MatcherAssert.assertThat(result.getTemplatePlaceholders().get(KEY), (Matcher)CoreMatchers.is((Object)EXPRESSION));
        MatcherAssert.assertThat((Object)result.getConfigFileProperties().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void sensitiveOnlyEnabledDoesDecryptsNonSensitiveString() {
        PolicyConfigurationEncryptionResult result = this.sensitiveOnlyEncrypter.encryptConfiguration(this.policyDefinition((Map<String, Object>)ImmutableMap.of((Object)KEY, (Object)ENCRYPTED_VALUE, (Object)KEY_2, (Object)SIMPLE_VALUE_2)), this.nonSensitiveSpecification());
        MatcherAssert.assertThat((Object)result.getConfigurationProperties().isEncrypted(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat(result.getConfigurationProperties().getConfiguration().get(KEY), (Matcher)CoreMatchers.is((Object)SIMPLE_VALUE));
        MatcherAssert.assertThat(result.getConfigurationProperties().getConfiguration().get(KEY_2), (Matcher)CoreMatchers.is((Object)SIMPLE_VALUE_2));
        MatcherAssert.assertThat(result.getTemplatePlaceholders().get(KEY), (Matcher)CoreMatchers.is((Object)SIMPLE_VALUE));
        MatcherAssert.assertThat(result.getTemplatePlaceholders().get(KEY_2), (Matcher)CoreMatchers.is((Object)SIMPLE_VALUE_2));
        MatcherAssert.assertThat((Object)result.getConfigFileProperties().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void encryptBoolean() {
        PolicyConfigurationEncryptionResult result = this.sensitiveOnlyEncrypter.encryptConfiguration(this.policyDefinition((Map<String, Object>)ImmutableMap.of((Object)KEY_BOOLEAN, (Object)true)), this.sensitiveSpecification());
        MatcherAssert.assertThat((Object)result.getConfigurationProperties().isEncrypted(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat(result.getConfigurationProperties().getConfiguration().get(KEY_BOOLEAN), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(result.getConfigFileProperties().get(KEY_BOOLEAN), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat(result.getTemplatePlaceholders().get(KEY_BOOLEAN), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void encryptNotDefinedKey() {
        PolicyConfigurationEncryptionResult result = this.sensitiveOnlyEncrypter.encryptConfiguration(this.policyDefinition((Map<String, Object>)ImmutableMap.of((Object)KEY_NOT_DEFINED, (Object)SIMPLE_VALUE)), this.sensitiveSpecification());
        MatcherAssert.assertThat((Object)result.getConfigurationProperties().isEncrypted(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat(result.getConfigurationProperties().getConfiguration().get(KEY_NOT_DEFINED), (Matcher)CoreMatchers.is((Object)SIMPLE_VALUE));
        MatcherAssert.assertThat(result.getConfigFileProperties().get(KEY_NOT_DEFINED), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat(result.getTemplatePlaceholders().get(KEY_NOT_DEFINED), (Matcher)CoreMatchers.is((Object)SIMPLE_VALUE));
    }

    @Test
    public void encryptListOfStrings() {
        PolicyConfigurationEncryptionResult result = this.sensitiveOnlyEncrypter.encryptConfiguration(this.policyDefinition((Map<String, Object>)ImmutableMap.of((Object)KEY_LIST_STRING, Arrays.asList(SIMPLE_VALUE, SIMPLE_VALUE_2))), this.sensitiveSpecification());
        MatcherAssert.assertThat((Object)result.getConfigurationProperties().isEncrypted(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((List)result.getConfigurationProperties().getConfiguration().get(KEY_LIST_STRING)), (Matcher)Matchers.contains((Object[])new String[]{ENCRYPTED_VALUE, ENCRYPTED_VALUE_2}));
        MatcherAssert.assertThat((Object)((List)result.getTemplatePlaceholders().get(KEY_LIST_STRING)), (Matcher)Matchers.contains((Object[])new String[]{this.encryptedTemplatePlaceholder("List_String.0"), this.encryptedTemplatePlaceholder("List_String.1")}));
        MatcherAssert.assertThat(((Map)result.getConfigFileProperties().get(KEY_LIST_STRING)).get("0"), (Matcher)CoreMatchers.is((Object)ENCRYPTED_VALUE));
        MatcherAssert.assertThat(((Map)result.getConfigFileProperties().get(KEY_LIST_STRING)).get("1"), (Matcher)CoreMatchers.is((Object)ENCRYPTED_VALUE_2));
    }

    @Test
    public void sensitiveOnlyEnabledDecryptsNonSensitiveListOfString() {
        PolicyConfigurationEncryptionResult result = this.sensitiveOnlyEncrypter.encryptConfiguration(this.policyDefinition((Map<String, Object>)ImmutableMap.of((Object)KEY_LIST_STRING, Arrays.asList(ENCRYPTED_VALUE, SIMPLE_VALUE_2))), this.nonSensitiveSpecification());
        MatcherAssert.assertThat((Object)result.getConfigurationProperties().isEncrypted(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)((List)result.getConfigurationProperties().getConfiguration().get(KEY_LIST_STRING)), (Matcher)Matchers.contains((Object[])new String[]{SIMPLE_VALUE, SIMPLE_VALUE_2}));
        MatcherAssert.assertThat((Object)((List)result.getTemplatePlaceholders().get(KEY_LIST_STRING)), (Matcher)Matchers.contains((Object[])new String[]{SIMPLE_VALUE, SIMPLE_VALUE_2}));
        MatcherAssert.assertThat(result.getConfigFileProperties().get(KEY_LIST_STRING), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void encryptKeyvalue() {
        ImmutableMap propertyMap = ImmutableMap.of((Object)"key", (Object)SIMPLE_KEY, (Object)"value", (Object)SIMPLE_VALUE);
        PolicyConfigurationEncryptionResult result = this.sensitiveOnlyEncrypter.encryptConfiguration(this.policyDefinition((Map<String, Object>)ImmutableMap.of((Object)KEY_KEYVALUE, (Object)propertyMap)), this.sensitiveSpecification());
        MatcherAssert.assertThat((Object)result.getConfigurationProperties().isEncrypted(), (Matcher)CoreMatchers.is((Object)true));
        this.assertKeyValue((Map)result.getConfigurationProperties().getConfiguration().get(KEY_KEYVALUE), SIMPLE_KEY, ENCRYPTED_VALUE);
        this.assertKeyValue((Map)result.getTemplatePlaceholders().get(KEY_KEYVALUE), SIMPLE_KEY, this.encryptedTemplatePlaceholder(KEY_KEYVALUE, SIMPLE_KEY));
        this.assertKeyValue((Map)result.getConfigFileProperties().get(KEY_KEYVALUE), SIMPLE_KEY, ENCRYPTED_VALUE);
    }

    @Test
    public void decryptKeyvalue() {
        ImmutableMap propertyMap = ImmutableMap.of((Object)"key", (Object)SIMPLE_KEY, (Object)"value", (Object)ENCRYPTED_VALUE);
        PolicyConfigurationEncryptionResult result = this.sensitiveOnlyEncrypter.encryptConfiguration(this.policyDefinition((Map<String, Object>)ImmutableMap.of((Object)KEY_KEYVALUE, (Object)propertyMap)), this.nonSensitiveSpecification());
        MatcherAssert.assertThat((Object)result.getConfigurationProperties().isEncrypted(), (Matcher)CoreMatchers.is((Object)false));
        this.assertKeyValue((Map)result.getConfigurationProperties().getConfiguration().get(KEY_KEYVALUE), SIMPLE_KEY, SIMPLE_VALUE);
        this.assertKeyValue((Map)result.getTemplatePlaceholders().get(KEY_KEYVALUE), SIMPLE_KEY, SIMPLE_VALUE);
        MatcherAssert.assertThat((Object)result.getConfigFileProperties().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void encryptListOfKeyvalues() {
        ImmutableMap propertyMap = ImmutableMap.of((Object)"key", (Object)SIMPLE_KEY, (Object)"value", (Object)SIMPLE_VALUE);
        ImmutableMap propertyMap2 = ImmutableMap.of((Object)"key", (Object)SIMPLE_KEY_2, (Object)"value", (Object)SIMPLE_VALUE_2);
        PolicyConfigurationEncryptionResult result = this.sensitiveOnlyEncrypter.encryptConfiguration(this.policyDefinition((Map<String, Object>)ImmutableMap.of((Object)KEY_LIST_KEYVALUES, Arrays.asList(propertyMap, propertyMap2))), this.sensitiveSpecification());
        MatcherAssert.assertThat((Object)result.getConfigurationProperties().isEncrypted(), (Matcher)CoreMatchers.is((Object)true));
        this.assertKeyValue((Map)((List)result.getConfigurationProperties().getConfiguration().get(KEY_LIST_KEYVALUES)).get(0), SIMPLE_KEY_2, ENCRYPTED_VALUE_2);
        this.assertKeyValue((Map)((List)result.getConfigurationProperties().getConfiguration().get(KEY_LIST_KEYVALUES)).get(1), SIMPLE_KEY, ENCRYPTED_VALUE);
        this.assertKeyValue((Map)((List)result.getTemplatePlaceholders().get(KEY_LIST_KEYVALUES)).get(0), SIMPLE_KEY_2, this.encryptedTemplatePlaceholder(KEY_LIST_KEYVALUES, SIMPLE_KEY_2));
        this.assertKeyValue((Map)((List)result.getTemplatePlaceholders().get(KEY_LIST_KEYVALUES)).get(1), SIMPLE_KEY, this.encryptedTemplatePlaceholder(KEY_LIST_KEYVALUES, SIMPLE_KEY));
        MatcherAssert.assertThat(((Map)result.getConfigFileProperties().get(KEY_LIST_KEYVALUES)).get(SIMPLE_KEY), (Matcher)CoreMatchers.is((Object)ENCRYPTED_VALUE));
        MatcherAssert.assertThat(((Map)result.getConfigFileProperties().get(KEY_LIST_KEYVALUES)).get(SIMPLE_KEY_2), (Matcher)CoreMatchers.is((Object)ENCRYPTED_VALUE_2));
    }

    @Test
    public void decryptListOfKeyValues() {
        ImmutableMap propertyMap = ImmutableMap.of((Object)"key", (Object)SIMPLE_KEY, (Object)"value", (Object)ENCRYPTED_VALUE);
        ImmutableMap propertyMap2 = ImmutableMap.of((Object)"key", (Object)SIMPLE_KEY_2, (Object)"value", (Object)SIMPLE_VALUE_2);
        PolicyConfigurationEncryptionResult result = this.sensitiveOnlyEncrypter.encryptConfiguration(this.policyDefinition((Map<String, Object>)ImmutableMap.of((Object)KEY_LIST_KEYVALUES, Arrays.asList(propertyMap, propertyMap2))), this.nonSensitiveSpecification());
        MatcherAssert.assertThat((Object)result.getConfigurationProperties().isEncrypted(), (Matcher)CoreMatchers.is((Object)false));
        this.assertKeyValue((Map)((List)result.getConfigurationProperties().getConfiguration().get(KEY_LIST_KEYVALUES)).get(0), SIMPLE_KEY, SIMPLE_VALUE);
        this.assertKeyValue((Map)((List)result.getConfigurationProperties().getConfiguration().get(KEY_LIST_KEYVALUES)).get(1), SIMPLE_KEY_2, SIMPLE_VALUE_2);
        this.assertKeyValue((Map)((List)result.getTemplatePlaceholders().get(KEY_LIST_KEYVALUES)).get(0), SIMPLE_KEY, SIMPLE_VALUE);
        this.assertKeyValue((Map)((List)result.getTemplatePlaceholders().get(KEY_LIST_KEYVALUES)).get(1), SIMPLE_KEY_2, SIMPLE_VALUE_2);
        MatcherAssert.assertThat((Object)result.getConfigFileProperties().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    private PolicyDefinition policyDefinition(Map<String, Object> configData) {
        PolicyDefinition policyDefinition = (PolicyDefinition)Mockito.mock(PolicyDefinition.class);
        Mockito.when((Object)policyDefinition.getConfigurationData()).thenReturn((Object)new PolicyConfiguration(configData));
        return policyDefinition;
    }

    private PolicySpecification sensitiveSpecification() {
        return this.mockSpecification(true);
    }

    private PolicySpecification nonSensitiveSpecification() {
        return this.mockSpecification(false);
    }

    private PolicySpecification mockSpecification(boolean sensitive) {
        PolicySpecification policySpecification = (PolicySpecification)Mockito.mock(PolicySpecification.class);
        Mockito.when((Object)policySpecification.getConfiguration()).thenReturn(this.buildMockedPolicyProperties(sensitive));
        Mockito.when((Object)policySpecification.isValid()).thenReturn((Object)true);
        return policySpecification;
    }

    private List<PolicyProperty> buildMockedPolicyProperties(boolean sensitive) {
        PolicyProperty policyProperty1 = new PolicyProperty();
        policyProperty1.setPropertyName(KEY);
        policyProperty1.setSensitive(sensitive);
        policyProperty1.setType("string");
        policyProperty1.setAllowMultiple(false);
        PolicyProperty policyProperty3 = new PolicyProperty();
        policyProperty3.setPropertyName(KEY_BOOLEAN);
        policyProperty3.setSensitive(sensitive);
        policyProperty3.setType("boolean");
        policyProperty3.setAllowMultiple(false);
        PolicyProperty policyProperty4 = new PolicyProperty();
        policyProperty4.setPropertyName(KEY_KEYVALUE);
        policyProperty4.setSensitive(sensitive);
        policyProperty4.setType("keyvalues");
        policyProperty4.setAllowMultiple(false);
        PolicyProperty policyProperty5 = new PolicyProperty();
        policyProperty5.setPropertyName(KEY_LIST_KEYVALUES);
        policyProperty5.setSensitive(sensitive);
        policyProperty5.setType("keyvalues");
        policyProperty5.setAllowMultiple(true);
        PolicyProperty policyProperty6 = new PolicyProperty();
        policyProperty6.setPropertyName(KEY_LIST_STRING);
        policyProperty6.setSensitive(sensitive);
        policyProperty6.setType("string");
        policyProperty6.setAllowMultiple(true);
        return Arrays.asList(policyProperty1, policyProperty3, policyProperty4, policyProperty5, policyProperty6);
    }

    private void assertKeyValue(Map<String, Object> keyvalue, String key, String value) {
        MatcherAssert.assertThat((Object)keyvalue.get("key"), (Matcher)CoreMatchers.is((Object)key));
        MatcherAssert.assertThat((Object)keyvalue.get("value"), (Matcher)CoreMatchers.is((Object)value));
    }

    private String encryptedTemplatePlaceholder(String property) {
        return String.format(ENCRYPTED_TEMPLATE_PLACEHOLDER, property);
    }

    private String encryptedTemplatePlaceholder(String property, String innerProperty) {
        return String.format(ENCRYPTED_TEMPLATE_PLACEHOLDER, property + "." + innerProperty);
    }
}

