/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.pointcut;

import com.github.valfirst.slf4jtest.LoggingEvent;
import com.github.valfirst.slf4jtest.TestLogger;
import com.github.valfirst.slf4jtest.TestLoggerFactory;
import com.mulesoft.anypoint.tests.logger.LogMatcher;
import com.mulesoft.mule.runtime.gw.api.policy.HttpResourcePointcut;
import com.mulesoft.mule.runtime.gw.policies.LogCleanup;
import com.mulesoft.mule.runtime.gw.policies.pointcut.IsHttpComponentPointcut;
import com.mulesoft.mule.runtime.gw.policies.pointcut.PointcutTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.policy.api.PolicyPointcutParameters;
import org.mule.tck.junit4.AbstractMuleTestCase;
import uk.org.lidalia.slf4jext.Level;

public class IsHttpComponentPointcutTestCase
extends AbstractMuleTestCase {
    @Rule
    public TestRule chain = RuleChain.outerRule((TestRule)new LogCleanup());
    private static final String POLICY_NAME = "name";
    private static final ComponentIdentifier INVALID_COMPONENT_IDENTIFIER = ComponentIdentifier.builder().namespace("invalid").name("component").build();
    private TestLogger logger;

    @Before
    public void setUp() {
        this.logger = TestLoggerFactory.getTestLogger(IsHttpComponentPointcut.class);
    }

    @Test
    public void httpListenerComponentIsValid() {
        IsHttpComponentPointcut pointcut = new IsHttpComponentPointcut(POLICY_NAME);
        PolicyPointcutParameters parameters = PointcutTestUtils.listenerPointcutParameters("");
        boolean matches = pointcut.matches(parameters);
        Assert.assertTrue((boolean)matches);
        Assert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.logger.getAllLoggingEvents().get(0), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.TRACE, "Request matches pointcut of policy {} since {} is a valid HTTP component.", new Object[]{POLICY_NAME, HttpResourcePointcut.HTTP_LISTENER_COMPONENT_IDENTIFIER})));
    }

    @Test
    public void httpRequesterComponentIsValid() {
        IsHttpComponentPointcut pointcut = new IsHttpComponentPointcut(POLICY_NAME);
        PolicyPointcutParameters parameters = PointcutTestUtils.requesterPointcutParameters("");
        boolean matches = pointcut.matches(parameters);
        Assert.assertTrue((boolean)matches);
        Assert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.logger.getAllLoggingEvents().get(0), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.TRACE, "Request matches pointcut of policy {} since {} is a valid HTTP component.", new Object[]{POLICY_NAME, HttpResourcePointcut.HTTP_REQUEST_COMPONENT_IDENTIFIER})));
    }

    @Test
    public void annotatedHttpListenerComponentIsValid() {
        IsHttpComponentPointcut pointcut = new IsHttpComponentPointcut(POLICY_NAME);
        PolicyPointcutParameters parameters = PointcutTestUtils.annotatedListenerPointcutParameters("");
        boolean matches = pointcut.matches(parameters);
        Assert.assertTrue((boolean)matches);
        Assert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)this.logger.getAllLoggingEvents().get(0), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.TRACE, "Annotation 'api-gateway:disablePolicies' has no effect on component {}", new Object[]{HttpResourcePointcut.HTTP_LISTENER_COMPONENT_IDENTIFIER})));
        Assert.assertThat((Object)this.logger.getAllLoggingEvents().get(1), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.TRACE, "Request matches pointcut of policy {} since {} is a valid HTTP component.", new Object[]{POLICY_NAME, HttpResourcePointcut.HTTP_LISTENER_COMPONENT_IDENTIFIER})));
    }

    @Test
    public void annotatedHttpRequesterComponentIsNotValid() {
        IsHttpComponentPointcut pointcut = new IsHttpComponentPointcut(POLICY_NAME);
        PolicyPointcutParameters parameters = PointcutTestUtils.annotatedRequesterPointcutParameters("");
        boolean matches = pointcut.matches(parameters);
        Assert.assertFalse((boolean)matches);
        Assert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)3));
        Assert.assertTrue((boolean)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)).getMessage().contains("is annotated with 'api-gateway:disablePolicies', no operation block policies will be applied to this element"));
        Assert.assertTrue((boolean)((LoggingEvent)this.logger.getAllLoggingEvents().get(1)).getMessage().contains("does not apply for pointcut for being annotated with 'api-gateway:disablePolicies'"));
        Assert.assertThat((Object)this.logger.getAllLoggingEvents().get(2), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.TRACE, "Request does not match pointcut of policy {} since {} is not a valid HTTP component.", new Object[]{POLICY_NAME, HttpResourcePointcut.HTTP_REQUEST_COMPONENT_IDENTIFIER})));
    }

    @Test
    public void multipleCallToAnnotatedHttpRequesterWarnsOnce() {
        IsHttpComponentPointcut pointcut = new IsHttpComponentPointcut(POLICY_NAME);
        PolicyPointcutParameters parameters = PointcutTestUtils.annotatedRequesterPointcutParameters("");
        boolean matches = pointcut.matches(parameters);
        Assert.assertFalse((boolean)matches);
        Assert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)3));
        Assert.assertTrue((boolean)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)).getMessage().contains("is annotated with 'api-gateway:disablePolicies', no operation block policies will be applied to this element"));
        Assert.assertTrue((boolean)((LoggingEvent)this.logger.getAllLoggingEvents().get(1)).getMessage().contains("does not apply for pointcut for being annotated with 'api-gateway:disablePolicies'"));
        Assert.assertThat((Object)this.logger.getAllLoggingEvents().get(2), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.TRACE, "Request does not match pointcut of policy {} since {} is not a valid HTTP component.", new Object[]{POLICY_NAME, HttpResourcePointcut.HTTP_REQUEST_COMPONENT_IDENTIFIER})));
        this.logger.clearAll();
        matches = pointcut.matches(parameters);
        Assert.assertFalse((boolean)matches);
        Assert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertTrue((boolean)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)).getMessage().contains("does not apply for pointcut for being annotated with 'api-gateway:disablePolicies'"));
        Assert.assertThat((Object)this.logger.getAllLoggingEvents().get(1), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.TRACE, "Request does not match pointcut of policy {} since {} is not a valid HTTP component.", new Object[]{POLICY_NAME, HttpResourcePointcut.HTTP_REQUEST_COMPONENT_IDENTIFIER})));
    }

    @Test
    public void anotherComponentIsNotValid() {
        IsHttpComponentPointcut pointcut = new IsHttpComponentPointcut(POLICY_NAME);
        PolicyPointcutParameters parameters = PointcutTestUtils.nonHttpPointcutParameters("");
        boolean matches = pointcut.matches(parameters);
        Assert.assertFalse((boolean)matches);
        Assert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.logger.getAllLoggingEvents().get(0), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.TRACE, "Request does not match pointcut of policy {} since {} is not a valid HTTP component.", new Object[]{POLICY_NAME, INVALID_COMPONENT_IDENTIFIER})));
    }
}

