/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.serialization;

import com.mulesoft.mule.runtime.gw.model.EmptyPolicySpecification;
import com.mulesoft.mule.runtime.gw.model.IdentityManagement;
import com.mulesoft.mule.runtime.gw.model.PolicySpecification;
import com.mulesoft.mule.runtime.gw.model.ValidPolicySpecification;
import com.mulesoft.mule.runtime.gw.policies.serialization.PolicySpecificationBuilder;
import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class PolicySpecificationSerializerTestCase {
    @Test
    public void parseNotExistantYamlFile() {
        File yamlSpec = new File("/xxxxxxx/specs/client-id-enforcement.yaml");
        PolicySpecification policySpecification = new PolicySpecificationBuilder().withFile(yamlSpec).build();
        MatcherAssert.assertThat((Object)policySpecification, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(EmptyPolicySpecification.class)));
        MatcherAssert.assertThat((Object)policySpecification.getId(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)policySpecification.getName(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)policySpecification.getSupportedPoliciesVersions(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)policySpecification.getDescription(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)policySpecification.getCategory(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)policySpecification.getType(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)policySpecification.getResourceLevelSupported(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)policySpecification.isStandalone(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)policySpecification.getViolationCategory(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)policySpecification.isValid(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void parseValidYaml() {
        File yamlSpec = new File(this.getClass().getResource("/specs/client-id-enforcement.yaml").getFile());
        PolicySpecification policySpecification = new PolicySpecificationBuilder().withFile(yamlSpec).build();
        MatcherAssert.assertThat((Object)policySpecification, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(ValidPolicySpecification.class)));
        MatcherAssert.assertThat((Object)policySpecification.getId(), (Matcher)Matchers.is((Object)"client-id-enforcement"));
        MatcherAssert.assertThat((Object)policySpecification.getName(), (Matcher)Matchers.is((Object)"Client ID enforcement"));
        MatcherAssert.assertThat((Object)policySpecification.getSupportedPoliciesVersions(), (Matcher)Matchers.is((Object)">=v1"));
        MatcherAssert.assertThat((Object)policySpecification.getDescription(), (Matcher)Matchers.is((Object)"All calls to the API must include a client ID and client secret for an application that is registered to use the API.\n\nThis policy will require updates to the RAML definition in order to function. You can obtain the RAML snippet and learn more [here](https://docs.mulesoft.com/anypoint-platform-for-apis/client-id-based-policies).\n"));
        MatcherAssert.assertThat((Object)policySpecification.getCategory(), (Matcher)Matchers.is((Object)"Compliance"));
        MatcherAssert.assertThat((Object)policySpecification.getType(), (Matcher)Matchers.is((Object)"system"));
        MatcherAssert.assertThat((Object)policySpecification.getResourceLevelSupported(), (Matcher)Matchers.is((Object)"true"));
        MatcherAssert.assertThat((Object)policySpecification.isStandalone(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)policySpecification.getViolationCategory(), (Matcher)Matchers.is((Object)"authentication"));
        MatcherAssert.assertThat((Object)policySpecification.isValid(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)policySpecification.getConfiguration().size(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void parseValidYamlWithIdentityManagement() {
        File yamlSpec = new File(this.getClass().getResource("/specs/openidconnect-access-token-enforcement.yaml").getFile());
        PolicySpecification policySpecification = new PolicySpecificationBuilder().withFile(yamlSpec).build();
        MatcherAssert.assertThat((Object)policySpecification, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(ValidPolicySpecification.class)));
        MatcherAssert.assertThat((Object)policySpecification.getId(), (Matcher)Matchers.is((Object)"openidconnect-access-token-enforcement"));
        MatcherAssert.assertThat((Object)policySpecification.getName(), (Matcher)Matchers.is((Object)"OpenId Connect access token enforcement"));
        MatcherAssert.assertThat((Object)policySpecification.getSupportedPoliciesVersions(), (Matcher)Matchers.is((Object)">=v4"));
        MatcherAssert.assertThat((Object)policySpecification.getDescription(), (Matcher)Matchers.is((Object)"Enforces access tokens by OpenId Connect.\n\nThis policy will require updates to the RAML/OAS definition in order to function.\nYou can obtain the RAML snippet and learn more [here](https://github.com/raml-org/raml-spec/blob/master/versions/raml-08/raml-08.md#security).\nYou can obtain OAS snippet and learn more [here](https://swagger.io/specification/v2/#securityRequirementObject).\n"));
        MatcherAssert.assertThat((Object)policySpecification.getCategory(), (Matcher)Matchers.is((Object)"Security"));
        MatcherAssert.assertThat((Object)policySpecification.getType(), (Matcher)Matchers.is((Object)"system"));
        MatcherAssert.assertThat((Object)policySpecification.getResourceLevelSupported(), (Matcher)Matchers.is((Object)"true"));
        MatcherAssert.assertThat((Object)policySpecification.isStandalone(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)policySpecification.getViolationCategory(), (Matcher)Matchers.is((Object)"authentication"));
        MatcherAssert.assertThat((Object)policySpecification.isValid(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((IdentityManagement)policySpecification.getIdentityManagement().get()).getType(), (Matcher)Matchers.is((Object)"OpenIDConnect"));
        MatcherAssert.assertThat((Object)policySpecification.getConfiguration().size(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void parseInvalidYaml() {
        File yamlSpec = new File(this.getClass().getResource("/specs/invalid.yaml").getFile());
        PolicySpecification policySpecification = new PolicySpecificationBuilder().withFile(yamlSpec).build();
        MatcherAssert.assertThat((Object)policySpecification, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(EmptyPolicySpecification.class)));
        MatcherAssert.assertThat((Object)policySpecification.getId(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)policySpecification.getName(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)policySpecification.getSupportedPoliciesVersions(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)policySpecification.getDescription(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)policySpecification.getCategory(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)policySpecification.getType(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)policySpecification.getResourceLevelSupported(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)policySpecification.isStandalone(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)policySpecification.getViolationCategory(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)policySpecification.isValid(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void parsePartiallyValidYaml() {
        File yamlSpec = new File(this.getClass().getResource("/specs/partial.yaml").getFile());
        PolicySpecification validPolicySpecification = new PolicySpecificationBuilder().withFile(yamlSpec).build();
        MatcherAssert.assertThat((Object)validPolicySpecification.getId(), (Matcher)Matchers.is((Object)"client-id-enforcement"));
        MatcherAssert.assertThat((Object)validPolicySpecification.getName(), (Matcher)Matchers.is((Object)"Client ID enforcement"));
        MatcherAssert.assertThat((Object)validPolicySpecification.getSupportedPoliciesVersions(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)validPolicySpecification.getDescription(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)validPolicySpecification.getCategory(), (Matcher)Matchers.is((Object)"Compliance"));
        MatcherAssert.assertThat((Object)validPolicySpecification.getType(), (Matcher)Matchers.is((Object)"system"));
        MatcherAssert.assertThat((Object)validPolicySpecification.getResourceLevelSupported(), (Matcher)Matchers.is((Object)"true"));
        MatcherAssert.assertThat((Object)validPolicySpecification.isStandalone(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)validPolicySpecification.getViolationCategory(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)validPolicySpecification.isValid(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)validPolicySpecification.getConfiguration(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }
}

