/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.service;

import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;
import java.util.Optional;

public class DeploymentStatusTestFactory {
    public static PolicyDefinitionDeploymentStatus appliedDefinition(PolicyDefinition definition) {
        return DeploymentStatusTestFactory.policyDefinition(definition, PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS);
    }

    public static PolicyDefinitionDeploymentStatus deploymentFailedDefinition(PolicyDefinition definition) {
        return DeploymentStatusTestFactory.policyDefinition(definition, PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_FAILED);
    }

    public static PolicyDefinitionDeploymentStatus downloadFailedDefinition(PolicyDefinition definition) {
        return DeploymentStatusTestFactory.policyDefinition(definition, PolicyDefinitionDeploymentStatus.DeploymentStatus.TEMPLATE_DOWNLOAD_FAILED);
    }

    public static PolicyDeploymentStatus applied(PolicyDefinition definition) {
        return new PolicyDeploymentStatus(new PolicyDefinitionDeploymentStatus(definition));
    }

    public static PolicyDeploymentStatus downloadFailed(PolicyDefinition def) {
        return DeploymentStatusTestFactory.policyFailed(def, PolicyDefinitionDeploymentStatus.DeploymentStatus.TEMPLATE_DOWNLOAD_FAILED);
    }

    public static PolicyDeploymentStatus deploymentFailed(PolicyDefinition def) {
        return DeploymentStatusTestFactory.policyFailed(def, PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_FAILED);
    }

    public static PolicyDeploymentStatus revertFailed(PolicyDefinition def) {
        return DeploymentStatusTestFactory.policyFailed(def, PolicyDefinitionDeploymentStatus.DeploymentStatus.REVERT_FAILED);
    }

    public static PolicyDeploymentStatus deploymentFailed(PolicyDefinition successful, PolicyDefinition failed) {
        return DeploymentStatusTestFactory.failedWithAppliedRevert(successful, failed, PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_FAILED);
    }

    public static PolicyDeploymentStatus downloadFailed(PolicyDefinition successful, PolicyDefinition failed) {
        return DeploymentStatusTestFactory.failedWithAppliedRevert(successful, failed, PolicyDefinitionDeploymentStatus.DeploymentStatus.TEMPLATE_DOWNLOAD_FAILED);
    }

    public static PolicyDeploymentStatus downloadFailed(PolicyDefinition successful, PolicyDefinition failed, Exception exception) {
        return new PolicyDeploymentStatus(new PolicyDefinitionDeploymentStatus(failed, PolicyDefinitionDeploymentStatus.DeploymentStatus.TEMPLATE_DOWNLOAD_FAILED, exception), Optional.of(new PolicyDefinitionDeploymentStatus(successful)));
    }

    public static PolicyDeploymentStatus policyApplied(PolicyDefinition definition, PolicyDefinitionDeploymentStatus.DeploymentStatus status) {
        if (status.equals((Object)PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS)) {
            return DeploymentStatusTestFactory.applied(definition);
        }
        return DeploymentStatusTestFactory.policyFailed(definition, status);
    }

    private static PolicyDeploymentStatus policyFailed(PolicyDefinition definition, PolicyDefinitionDeploymentStatus.DeploymentStatus status) {
        return new PolicyDeploymentStatus(DeploymentStatusTestFactory.policyDefinition(definition, status), Optional.empty());
    }

    private static PolicyDeploymentStatus failedWithAppliedRevert(PolicyDefinition successful, PolicyDefinition failed, PolicyDefinitionDeploymentStatus.DeploymentStatus cause) {
        return new PolicyDeploymentStatus(DeploymentStatusTestFactory.policyDefinition(failed, cause), Optional.of(DeploymentStatusTestFactory.appliedDefinition(successful)));
    }

    private static PolicyDefinitionDeploymentStatus policyDefinition(PolicyDefinition definition, PolicyDefinitionDeploymentStatus.DeploymentStatus status) {
        return new PolicyDefinitionDeploymentStatus(definition, status, null);
    }
}

