/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.service;

import com.google.common.collect.Lists;
import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.service.DefaultMultiplexingPolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.DefaultPolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.policies.service.MultiplexingPolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.policies.service.TransactionalPolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.store.DefaultPolicyStore;
import com.mulesoft.mule.runtime.gw.policies.store.EncryptedPropertiesSerializer;
import com.mulesoft.mule.runtime.gw.policies.template.PolicyTemplate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemPropertyTemporaryFolder;

@RunWith(value=MockitoJUnitRunner.class)
public class MultiplexingPolicyDeploymentServiceTestCase
extends AbstractMuleTestCase {
    private static final String RESOLVED_TEMPLATE = "resolvedTemplate";
    @Rule
    public SystemPropertyTemporaryFolder temporaryFolder = new SystemPropertyTemporaryFolder("mule.home");
    @Mock
    private TransactionalPolicyDeploymentService policyDeployer;
    @Mock
    private ApiService apiService;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Api api;
    private Policy policy;
    private PolicyDefinition policyDefinition;
    private MultiplexingPolicyDeploymentService policyDeploymentService;
    private PolicyDeploymentTracker policyDeploymentTracker;
    @Mock
    private PolicyFactory policyFactory;
    @Mock
    private PolicyTemplate policyTemplate;

    @Before
    public void setUp() {
        Mockito.when((Object)this.apiService.get(PolicyTestValuesConstants.API_KEY)).thenReturn(Optional.of(this.api));
        DefaultPolicyStore policyStore = new DefaultPolicyStore(new EncryptedPropertiesSerializer());
        this.policyDeploymentTracker = new DefaultPolicyDeploymentTracker();
        this.policyDeploymentService = new DefaultMultiplexingPolicyDeploymentService(this.apiService, this.policyDeploymentTracker, this.policyDeployer);
        this.policyDefinition = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 1, new PolicyConfiguration(Collections.emptyMap()));
        this.policy = new Policy(this.policyTemplate, this.policyDefinition, RESOLVED_TEMPLATE);
        Mockito.when((Object)this.policyFactory.createFromPolicyDefinition(this.policyDefinition)).thenReturn((Object)this.policy);
    }

    @Test
    public void newPolicySingleApi() {
        this.policyDeploymentService.newPolicy(this.policyDefinition);
        ((TransactionalPolicyDeploymentService)Mockito.verify((Object)this.policyDeployer)).deploy(this.policyDefinition, this.api);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeployer});
    }

    @Test
    public void newPolicyMultipleApis() {
        ApiImplementation implementation2 = (ApiImplementation)Mockito.mock(ApiImplementation.class);
        Api api2 = (Api)Mockito.mock(Api.class);
        Mockito.when((Object)api2.getImplementation()).thenReturn((Object)implementation2);
        this.policyDefinition = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, (List)Lists.newArrayList((Object[])new ApiKey[]{PolicyTestValuesConstants.API_KEY, PolicyTestValuesConstants.API_KEY_2}), null, 1, new PolicyConfiguration(Collections.emptyMap()));
        Mockito.when((Object)this.apiService.get(PolicyTestValuesConstants.API_KEY_2)).thenReturn(Optional.of(api2));
        this.policy = new Policy(this.policyTemplate, this.policyDefinition, RESOLVED_TEMPLATE);
        this.policyDeploymentService.newPolicy(this.policyDefinition);
        ((TransactionalPolicyDeploymentService)Mockito.verify((Object)this.policyDeployer)).deploy(this.policyDefinition, this.api);
        ((TransactionalPolicyDeploymentService)Mockito.verify((Object)this.policyDeployer)).deploy(this.policyDefinition, api2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeployer});
    }

    @Test
    public void newPolicyForSpecificNotExistingApi() {
        Mockito.when((Object)this.apiService.get(PolicyTestValuesConstants.API_KEY_2)).thenReturn(Optional.empty());
        this.policyDefinition = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, (List)Lists.newArrayList((Object[])new ApiKey[]{PolicyTestValuesConstants.API_KEY_2}), null, 1, new PolicyConfiguration(Collections.emptyMap()));
        this.policyDeploymentService.newPolicy(this.policyDefinition);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeployer});
    }

    @Test
    public void policyRemoved() {
        this.policyDeploymentService.removePolicy(this.policyDefinition);
        ((TransactionalPolicyDeploymentService)Mockito.verify((Object)this.policyDeployer)).undeploy(this.policyDefinition, this.api);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeployer});
    }

    @Test
    public void multipleApisPolicyRemoved() {
        ApiImplementation implementation2 = (ApiImplementation)Mockito.mock(ApiImplementation.class);
        Api api2 = (Api)Mockito.mock(Api.class);
        Mockito.when((Object)api2.getImplementation()).thenReturn((Object)implementation2);
        this.policyDefinition = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, (List)Lists.newArrayList((Object[])new ApiKey[]{PolicyTestValuesConstants.API_KEY, PolicyTestValuesConstants.API_KEY_2}), null, 1, new PolicyConfiguration(Collections.emptyMap()));
        this.policy = new Policy(this.policyTemplate, this.policyDefinition, RESOLVED_TEMPLATE);
        Mockito.when((Object)this.apiService.get(PolicyTestValuesConstants.API_KEY_2)).thenReturn(Optional.of(api2));
        this.policyDeploymentService.removePolicy(this.policyDefinition);
        ((TransactionalPolicyDeploymentService)Mockito.verify((Object)this.policyDeployer)).undeploy(this.policyDefinition, this.api);
        ((TransactionalPolicyDeploymentService)Mockito.verify((Object)this.policyDeployer)).undeploy(this.policyDefinition, api2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeployer});
    }

    @Test
    public void policyRemovedById() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, new PolicyDeploymentStatus(new PolicyDefinitionDeploymentStatus(this.policyDefinition)));
        this.policyDeploymentService.removePolicyById(this.policyDefinition.getId());
        ((TransactionalPolicyDeploymentService)Mockito.verify((Object)this.policyDeployer)).undeploy(this.policyDefinition, this.api);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeployer});
    }

    @Test
    public void policyUpdated() {
        PolicyDefinition updatedDefinition = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 2, new PolicyConfiguration(Collections.emptyMap()));
        this.policyDeploymentService.updatePolicy(this.policyDefinition, updatedDefinition);
        ((TransactionalPolicyDeploymentService)Mockito.verify((Object)this.policyDeployer)).update(this.policyDefinition, updatedDefinition, this.api);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeployer});
    }
}

