/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.template;

import com.github.valfirst.slf4jtest.LoggingEvent;
import com.github.valfirst.slf4jtest.TestLogger;
import com.github.valfirst.slf4jtest.TestLoggerFactory;
import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.anypoint.tests.logger.LogMatcher;
import com.mulesoft.mule.runtime.gw.api.PolicyFolders;
import com.mulesoft.mule.runtime.gw.client.ApiPlatformClient;
import com.mulesoft.mule.runtime.gw.client.dto.PolicyTemplateDto;
import com.mulesoft.mule.runtime.gw.model.EmptyPolicySpecification;
import com.mulesoft.mule.runtime.gw.policies.LogCleanup;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyTemplateStore;
import com.mulesoft.mule.runtime.gw.policies.template.PolicyTemplate;
import com.mulesoft.mule.runtime.gw.policies.template.exception.PolicyTemplateAssetException;
import com.mulesoft.mule.runtime.gw.policies.template.provider.FileSystemPolicyTemplateProvider;
import com.mulesoft.mule.runtime.gw.policies.template.provider.GatewayPolicyTemplateDescriptorFactory;
import com.mulesoft.mule.runtime.gw.policies.template.provider.PolicyTemplateProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URISyntaxException;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;
import org.mule.tck.ZipUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemPropertyTemporaryFolder;
import uk.org.lidalia.slf4jext.Level;

public class FileSystemPolicyTemplateProviderTestCase
extends AbstractMuleTestCase {
    private static final String VALID_YAML_RESOURCE = "/specs/client-id-enforcement.yaml";
    private static final String INVALID_YAML_RESOURCE = "/specs/invalid.yaml";
    @Rule
    public TemporaryFolder muleHome = new SystemPropertyTemporaryFolder("mule.home");
    @Rule
    public TestRule chain = RuleChain.outerRule((TestRule)new LogCleanup());
    private PolicyTemplateDescriptor templateDescriptor;
    private ApiPlatformClient restClient;
    private GatewayPolicyTemplateDescriptorFactory templateDescriptorFactory;
    private PolicyTemplateProvider templateProvider;
    private TestLogger logger;

    @Before
    public void setUp() throws IllegalAccessException {
        this.templateDescriptorFactory = (GatewayPolicyTemplateDescriptorFactory)Mockito.mock(GatewayPolicyTemplateDescriptorFactory.class);
        this.templateDescriptor = new PolicyTemplateDescriptor("name");
        this.templateDescriptor.setRootFolder(PolicyFolders.getPolicyTemplatesTempFolder());
        this.restClient = (ApiPlatformClient)Mockito.mock(ApiPlatformClient.class);
        this.logger = TestLoggerFactory.getTestLogger(PolicyTemplateProvider.class);
        Mockito.when((Object)this.templateDescriptorFactory.create((File)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any())).thenReturn((Object)this.templateDescriptor);
        this.templateProvider = new FileSystemPolicyTemplateProvider(this.restClient, this.templateDescriptorFactory, new PolicyTemplateStore());
    }

    @Test
    public void provideHeavyWeightTemplate() throws IOException {
        this.createTemplateJarFile(String.format("%s-mule-policy.jar", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getName()));
        this.createTemplateYamlFile(String.format("%s.yaml", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getName()), VALID_YAML_RESOURCE);
        PolicyTemplate policyTemplate = this.templateProvider.provide(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY);
        Assert.assertThat((Object)policyTemplate.getKey(), (Matcher)Matchers.is((Object)PolicyTestValuesConstants.POLICY_TEMPLATE_KEY));
        Assert.assertThat((Object)policyTemplate.getTemplateFile(), (Matcher)Matchers.is((Object)new File(PolicyFolders.getPolicyTemplatesTempFolder(), policyTemplate.getKey().getName() + "/template.xml")));
        Assert.assertThat((Object)policyTemplate.getTemplateDescriptor(), (Matcher)Matchers.is((Object)this.templateDescriptor));
        Assert.assertThat((Object)PolicyFolders.getPolicyTemplatesTempFolder().listFiles(), (Matcher)Matchers.arrayWithSize((int)1));
        ((GatewayPolicyTemplateDescriptorFactory)Mockito.verify((Object)this.templateDescriptorFactory, (VerificationMode)Mockito.times((int)1))).create((File)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.restClient});
    }

    @Test
    public void provideDownloadedTemplate() throws IOException, URISyntaxException {
        File templateFile = this.createAnotherTemplateFile();
        File yamlFile = new File(((Object)((Object)this)).getClass().getResource(VALID_YAML_RESOURCE).getFile());
        String downloadJarLink = "downloadJarLink";
        String downloadYamlLink = "downloadYamlLink";
        PolicyTemplateDto templateDTO = new PolicyTemplateDto();
        templateDTO.setJarDownloadLink(downloadJarLink);
        templateDTO.setYamlDownloadLink(downloadYamlLink);
        Mockito.when((Object)this.restClient.getPolicyTemplateMetadata(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY)).thenReturn((Object)templateDTO);
        Mockito.when((Object)this.restClient.downloadTemplateAsset(downloadJarLink)).thenReturn((Object)org.apache.commons.io.FileUtils.openInputStream((File)templateFile));
        Mockito.when((Object)this.restClient.downloadTemplateAsset(downloadYamlLink)).thenReturn((Object)org.apache.commons.io.FileUtils.openInputStream((File)yamlFile));
        PolicyTemplate policyTemplate = this.templateProvider.provide(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY);
        Assert.assertThat((Object)policyTemplate.getKey(), (Matcher)Matchers.is((Object)PolicyTestValuesConstants.POLICY_TEMPLATE_KEY));
        Assert.assertThat((Object)policyTemplate.getTemplateFile(), (Matcher)Matchers.is((Object)new File(PolicyFolders.getPolicyTemplatesTempFolder(), policyTemplate.getKey().getName() + "/template.xml")));
        Assert.assertThat((Object)policyTemplate.getTemplateDescriptor(), (Matcher)Matchers.is((Object)this.templateDescriptor));
        Assert.assertThat((Object)PolicyFolders.getPolicyTemplatesTempFolder().listFiles(), (Matcher)Matchers.arrayWithSize((int)1));
        ((ApiPlatformClient)Mockito.verify((Object)this.restClient)).downloadTemplateAsset(downloadJarLink);
        ((ApiPlatformClient)Mockito.verify((Object)this.restClient)).downloadTemplateAsset(downloadYamlLink);
        ((ApiPlatformClient)Mockito.verify((Object)this.restClient)).getPolicyTemplateMetadata(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY);
        ((GatewayPolicyTemplateDescriptorFactory)Mockito.verify((Object)this.templateDescriptorFactory, (VerificationMode)Mockito.times((int)1))).create((File)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.restClient});
    }

    @Test
    public void provideTwiceDoesNotRecreateTemplate() throws IOException {
        this.createTemplateJarFile(String.format("%s-mule-policy.jar", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getName()));
        this.createTemplateYamlFile(String.format("%s.yaml", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getName()), VALID_YAML_RESOURCE);
        this.templateProvider.provide(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY);
        PolicyTemplate policyTemplate = this.templateProvider.provide(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY);
        Assert.assertThat((Object)policyTemplate.getKey(), (Matcher)Matchers.is((Object)PolicyTestValuesConstants.POLICY_TEMPLATE_KEY));
        Assert.assertThat((Object)policyTemplate.getTemplateFile(), (Matcher)Matchers.is((Object)new File(PolicyFolders.getPolicyTemplatesTempFolder(), policyTemplate.getKey().getName() + "/template.xml")));
        Assert.assertThat((Object)policyTemplate.getTemplateDescriptor(), (Matcher)Matchers.is((Object)this.templateDescriptor));
        Assert.assertThat((Object)PolicyFolders.getPolicyTemplatesTempFolder().listFiles(), (Matcher)Matchers.arrayWithSize((int)1));
        ((GatewayPolicyTemplateDescriptorFactory)Mockito.verify((Object)this.templateDescriptorFactory, (VerificationMode)Mockito.times((int)1))).create((File)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.restClient});
    }

    @Test
    public void provideRecreatesIfTempFolderDeleted() throws IOException {
        this.createTemplateJarFile(String.format("%s-mule-policy.jar", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getName()));
        this.createTemplateYamlFile(String.format("%s.yaml", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getName()), VALID_YAML_RESOURCE);
        this.templateProvider.provide(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY);
        FileUtils.deleteTree((File)PolicyFolders.getPolicyTemplatesTempFolder());
        PolicyTemplate policyTemplate = this.templateProvider.provide(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY);
        Assert.assertThat((Object)policyTemplate.getKey(), (Matcher)Matchers.is((Object)PolicyTestValuesConstants.POLICY_TEMPLATE_KEY));
        Assert.assertThat((Object)policyTemplate.getTemplateFile(), (Matcher)Matchers.is((Object)new File(PolicyFolders.getPolicyTemplatesTempFolder(), policyTemplate.getKey().getName() + "/template.xml")));
        Assert.assertThat((Object)policyTemplate.getTemplateDescriptor(), (Matcher)Matchers.is((Object)this.templateDescriptor));
        Assert.assertThat((Object)PolicyFolders.getPolicyTemplatesTempFolder().listFiles(), (Matcher)Matchers.arrayWithSize((int)1));
        ((GatewayPolicyTemplateDescriptorFactory)Mockito.verify((Object)this.templateDescriptorFactory, (VerificationMode)Mockito.times((int)2))).create((File)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.restClient});
    }

    @Test
    public void templateMetadataError() throws IOException {
        Mockito.when((Object)this.restClient.getPolicyTemplateMetadata(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY)).thenThrow(new Throwable[]{new RuntimeException()});
        try {
            this.templateProvider.provide(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY);
            Assert.fail((String)"Template download should fail");
        }
        catch (PolicyTemplateAssetException policyTemplateAssetException) {
            // empty catch block
        }
        Assert.assertThat((Object)PolicyFolders.getPolicyTemplatesTempFolder().exists(), (Matcher)Matchers.is((Object)false));
        ((ApiPlatformClient)Mockito.verify((Object)this.restClient)).getPolicyTemplateMetadata(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.restClient});
    }

    @Test
    public void templateJarDownloadError() throws IOException, URISyntaxException {
        String downloadLink = "jarDownloadLink";
        PolicyTemplateDto templateDto = new PolicyTemplateDto();
        templateDto.setJarDownloadLink(downloadLink);
        Mockito.when((Object)this.restClient.getPolicyTemplateMetadata(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY)).thenReturn((Object)templateDto);
        Mockito.when((Object)this.restClient.downloadTemplateAsset(downloadLink)).thenThrow(new Throwable[]{new RuntimeException()});
        try {
            this.templateProvider.provide(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY);
            Assert.fail((String)"Template download should fail");
        }
        catch (PolicyTemplateAssetException policyTemplateAssetException) {
            // empty catch block
        }
        Assert.assertThat((Object)PolicyFolders.getPolicyTemplatesTempFolder().exists(), (Matcher)Matchers.is((Object)false));
        ((ApiPlatformClient)Mockito.verify((Object)this.restClient)).getPolicyTemplateMetadata(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY);
        ((ApiPlatformClient)Mockito.verify((Object)this.restClient)).downloadTemplateAsset(downloadLink);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.restClient});
    }

    @Test
    public void templateYamlDownloadError() throws IOException, URISyntaxException {
        String downloadYamlLink = "yamlDownloadLink";
        String downloadJarLink = "jarDownloadLink";
        PolicyTemplateDto templateDto = new PolicyTemplateDto();
        templateDto.setYamlDownloadLink(downloadYamlLink);
        templateDto.setJarDownloadLink(downloadJarLink);
        Mockito.when((Object)this.restClient.getPolicyTemplateMetadata(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY)).thenReturn((Object)templateDto);
        Mockito.when((Object)this.restClient.downloadTemplateAsset(downloadJarLink)).thenReturn((Object)new FileInputStream(this.createAnotherTemplateFile()));
        Mockito.when((Object)this.restClient.downloadTemplateAsset(downloadYamlLink)).thenThrow(new Throwable[]{new RuntimeException()});
        PolicyTemplate template = this.templateProvider.provide(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY);
        Assert.assertThat((Object)template.getPolicySpecification(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(EmptyPolicySpecification.class)));
        Assert.assertThat((Object)PolicyFolders.getPolicyTemplatesTempFolder().exists(), (Matcher)Matchers.is((Object)true));
        ((ApiPlatformClient)Mockito.verify((Object)this.restClient)).getPolicyTemplateMetadata(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY);
        ((ApiPlatformClient)Mockito.verify((Object)this.restClient)).downloadTemplateAsset(downloadJarLink);
        ((ApiPlatformClient)Mockito.verify((Object)this.restClient)).downloadTemplateAsset(downloadYamlLink);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.restClient});
    }

    @Test
    public void invalidYamlParsing() throws IOException {
        this.createTemplateJarFile(String.format("%s-mule-policy.jar", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getName()));
        this.createTemplateYamlFile(String.format("%s.yaml", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getName()), INVALID_YAML_RESOURCE);
        PolicyTemplate policyTemplate = this.templateProvider.provide(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY);
        Assert.assertThat((Object)policyTemplate.getKey(), (Matcher)Matchers.is((Object)PolicyTestValuesConstants.POLICY_TEMPLATE_KEY));
        Assert.assertThat((Object)policyTemplate.getTemplateFile(), (Matcher)Matchers.is((Object)new File(PolicyFolders.getPolicyTemplatesTempFolder(), policyTemplate.getKey().getName() + "/template.xml")));
        Assert.assertThat((Object)policyTemplate.getTemplateDescriptor(), (Matcher)Matchers.is((Object)this.templateDescriptor));
        Assert.assertThat((Object)PolicyFolders.getPolicyTemplatesTempFolder().listFiles(), (Matcher)Matchers.arrayWithSize((int)1));
        Assert.assertThat((Object)policyTemplate.getPolicySpecification(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(EmptyPolicySpecification.class)));
        ((GatewayPolicyTemplateDescriptorFactory)Mockito.verify((Object)this.templateDescriptorFactory, (VerificationMode)Mockito.times((int)1))).create((File)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.restClient});
    }

    @Test
    public void templateUnzipError() throws IOException {
        File templateJar = this.createInvalidTemplateFile(String.format("%s-mule-policy.jar", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getName()));
        this.createTemplateYamlFile(String.format("%s.yaml", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getName()), VALID_YAML_RESOURCE);
        Assert.assertThat((Object)templateJar.exists(), (Matcher)Matchers.is((Object)true));
        try {
            this.templateProvider.provide(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY);
            Assert.fail((String)"Template unzipping should fail");
        }
        catch (PolicyTemplateAssetException exception) {
            Assert.assertThat((Object)templateJar.exists(), (Matcher)Matchers.is((Object)false));
            Assert.assertThat((Object)this.logger.getAllLoggingEvents().get(0), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "Policy template JAR {} was deleted successfully", new Object[]{templateJar.getName()})));
        }
    }

    private void createTemplateJarFile(String templateFileName) throws IOException {
        File zipFile = new File(PolicyFolders.getPolicyTemplatesFolder(), templateFileName);
        File zipFileContent = new File(this.muleHome.getRoot(), "template.xml");
        zipFileContent.createNewFile();
        ZipUtils.compress((File)zipFile, (ZipUtils.ZipResource[])new ZipUtils.ZipResource[]{new ZipUtils.ZipResource(zipFileContent.getAbsolutePath(), zipFileContent.getName())});
    }

    private File createTemplateYamlFile(String templateYamlFileName, String resource) throws IOException {
        File yamlFile = new File(PolicyFolders.getPolicyTemplatesFolder(), templateYamlFileName);
        yamlFile.createNewFile();
        org.apache.commons.io.FileUtils.copyInputStreamToFile((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(resource), (File)yamlFile);
        return yamlFile;
    }

    private File createAnotherTemplateFile() throws IOException {
        File zipFile = this.muleHome.newFile();
        File zipFileContent = new File(this.muleHome.getRoot(), "zipContent");
        zipFileContent.createNewFile();
        ZipUtils.compress((File)zipFile, (ZipUtils.ZipResource[])new ZipUtils.ZipResource[]{new ZipUtils.ZipResource(zipFileContent.getAbsolutePath(), zipFileContent.getName())});
        return zipFile;
    }

    private File createInvalidTemplateFile(String templateFileName) throws IOException {
        File zipFile = new File(PolicyFolders.getPolicyTemplatesFolder(), templateFileName);
        File zipFileContent = new File(this.muleHome.getRoot(), "template.xml");
        zipFileContent.createNewFile();
        ZipUtils.compress((File)zipFile, (ZipUtils.ZipResource[])new ZipUtils.ZipResource[]{new ZipUtils.ZipResource(zipFileContent.getAbsolutePath(), zipFileContent.getName())});
        RandomAccessFile raf = new RandomAccessFile(zipFile, "rw");
        raf.seek(20L);
        raf.writeBytes("i_am_currupting_a_jar_file");
        raf.seek(189L);
        raf.writeBytes("i_am_so_evil_hahahaha");
        raf.close();
        return zipFile;
    }
}

