/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.encryption.encrypter;

import static java.lang.String.join;

import com.mulesoft.mule.runtime.gw.internal.encryption.RuntimeEncrypter;
import com.mulesoft.mule.runtime.gw.model.PolicyProperty;
import com.mulesoft.mule.runtime.gw.policies.encryption.EncryptedValueResult;
import com.mulesoft.mule.runtime.gw.policies.encryption.filter.StringListTypeFilter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * Knows how to encrypt and decrypt multiple config values that are represented with a {@link String}
 */
public class ListOfStringsEncrypter extends PolicyTypeEncrypter<List<String>> {

  public ListOfStringsEncrypter(RuntimeEncrypter runtimeEncrypter, boolean isSensitiveOnlyEnabled,
                                List<PolicyProperty> policyProperties) {
    super(runtimeEncrypter, isSensitiveOnlyEnabled, policyProperties);
  }

  @Override
  protected EncryptedValueResult encryptSingle(String key, List<String> values) {
    Map<String, String> configFile = new HashMap<>();
    List<String> templateList = new ArrayList<>();
    List<String> configData = new ArrayList<>();

    for (int i = 0; i < values.size(); i++) {
      String replacementKey = join("", key, ".", String.valueOf(i));
      String templateValue = join("", TEMPLATE_PREFIX, replacementKey, TEMPLATE_SUFFIX);
      templateList.add(templateValue);

      String encrypted = encrypt(values.get(i));
      configFile.put(String.valueOf(i), encrypted);
      configData.add(encrypted);
    }

    return new EncryptedValueResult<>(key, templateList, configData, configFile);
  }

  @Override
  protected EncryptedValueResult decryptSingle(String key, List<String> value) {
    List<String> decrypted = value.stream().map(this::decrypt).collect(Collectors.toList());

    return new EncryptedValueResult<>(key, decrypted, decrypted);
  }

  @Override
  protected boolean supports(String key, Optional<PolicyProperty> property) {
    return property.isPresent() && new StringListTypeFilter().test(property.get());
  }
}
