/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.encryption.encrypter;

import com.mulesoft.mule.runtime.gw.internal.encryption.RuntimeEncrypter;
import com.mulesoft.mule.runtime.gw.model.PolicyProperty;

import java.util.ArrayList;
import java.util.List;

public class PolicyTypeEncrypters {

  private final List<PolicyTypeEncrypter> encrypters;
  private final NullEncrypter nullEncrypter;

  public PolicyTypeEncrypters(RuntimeEncrypter runtimeEncrypter, boolean isSensitiveOnlyEnabled,
                              List<PolicyProperty> policyProperties) {
    encrypters = new ArrayList<>();
    encrypters.add(new StringEncrypter(runtimeEncrypter, isSensitiveOnlyEnabled, policyProperties));
    encrypters.add(new KeyvalueEncrypter(runtimeEncrypter, isSensitiveOnlyEnabled, policyProperties));
    encrypters.add(new ListOfStringsEncrypter(runtimeEncrypter, isSensitiveOnlyEnabled, policyProperties));
    encrypters.add(new ListOfKeyvaluesEncrypter(runtimeEncrypter, isSensitiveOnlyEnabled, policyProperties));
    nullEncrypter = new NullEncrypter();
  }

  public PolicyTypeEncrypter getEncrypter(String key) {
    return encrypters.stream()
        .filter(policyConfigDataEncrypter -> policyConfigDataEncrypter.supports(key))
        .findFirst()
        .orElse(nullEncrypter);
  }
}
