/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.notification;

import com.mulesoft.mule.runtime.gw.model.PolicySpecification;
import org.mule.runtime.api.notification.NotificationListener;

import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;

import java.util.Optional;

public interface PolicyNotificationListenerSupplier {

  /**
   * Supplies a notification listener that will be injected in the policy's context. It can return empty if the supplier decides
   * that it should not inject the listener to the input policy.
   * 
   * @param apiImplementation API implementation where the policy will be injected
   * @param policyDefinition policy whose context will be injected with the supplied listener
   * @return the notification listener to inject or empty
   */
  Optional<NotificationListener> supply(ApiImplementation apiImplementation, PolicyDefinition policyDefinition,
                                        PolicySpecification policySpecification);
}
