/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.service;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;

import java.util.List;
import java.util.Optional;

/**
 * Keeps track of the deployment status of the policies
 */
public interface PolicyDeploymentTracker {

  void addPolicyDeploymentListener(PolicyDeploymentListener listener);

  /**
   * Removes every deployment status of the specified api
   * 
   * @param apiKey api
   * @return the list of policies for that api or empty if there are none
   */
  List<PolicyDefinition> apiRemoved(ApiKey apiKey);

  /**
   * Removes the deployment status of the specified policy
   * 
   * @param apiKey the api owner of the policy
   * @param policyName name of the policy that was removed
   */
  void policyRemoved(ApiKey apiKey, String policyName);

  /**
   * Updates the deployment status of the specified policy
   * 
   * @param apiKey the api owner of the policy
   * @param policyDeploymentStatus the deployment status
   */
  void policyDeployed(ApiKey apiKey, PolicyDeploymentStatus policyDeploymentStatus);

  /**
   * Returns the statuses of the online policies that are being tracked
   * 
   * @param apiKey the api of the policies to return
   * @return the list of online policy statuses or empty if there are none
   */
  List<PolicyDeploymentStatus> onlinePolicyStatuses(ApiKey apiKey);

  /**
   * Returns the statuses of the policies that are being tracked
   *
   * @param apiKey the api of the policies to return
   * @return the list of policy statuses or empty if there are none
   */
  List<PolicyDeploymentStatus> policyStatuses(ApiKey apiKey);

  /**
   * Looks for a policy through the existing deployments
   * 
   * @param policyName name of the policy to look for
   * @return the policy definition or empty if non found
   */
  Optional<PolicyDefinition> findByName(String policyName);

  /**
   * Whether a policy has existing deployments or not
   * 
   * @param policyName the policy name
   * @return true if there are deployments, false otherwise
   */
  boolean hasDeployments(String policyName);
}
