/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.service.detection.change;

import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;

/**
 * Represents the action that must be taken to consolidate the current status with with the desired status.
 *
 * Additionally, the current status can be safely recovered if the action fails.
 */
public abstract class RecoverableChangeType extends ChangeType {

  private final PolicyDefinition appliedDefinition;

  public RecoverableChangeType(PolicyDefinition appliedDefinition, PolicyDefinition definition) {
    super(definition);
    this.appliedDefinition = appliedDefinition;
  }

  public PolicyDefinition getAppliedDefinition() {
    return appliedDefinition;
  }
}
