/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.template.resolver;

import static org.apache.commons.io.FileUtils.readFileToString;

import com.mulesoft.mule.runtime.gw.policies.template.PolicyTemplate;
import com.mulesoft.mule.runtime.gw.policies.template.exception.PolicyTemplateResolverException;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.io.StringTemplateSource;
import com.github.jknack.handlebars.io.TemplateSource;

import java.util.Map;
import java.util.Objects;

public class HandlebarsPolicyTemplateResolver implements PolicyTemplateResolver {

  private static final String EQUALS_HELPER = "equals";

  private final Handlebars handlebars;

  public HandlebarsPolicyTemplateResolver() {
    handlebars = new Handlebars();
    handlebars.prettyPrint(true);
    handlebars.registerHelper(EQUALS_HELPER, (Helper<String>) (value, options) -> Objects.equals(value, options.param(0)));
  }

  @Override
  public String resolve(PolicyTemplate policyTemplate, Map<String, Object> configurationData)
      throws PolicyTemplateResolverException {

    try {
      TemplateSource templateSource = new StringTemplateSource(policyTemplate.getKey().getName(),
                                                               readFileToString(policyTemplate.getTemplateFile()));
      Template template = handlebars.compile(templateSource);
      return template.apply(configurationData);

    } catch (Exception e) {
      throw new PolicyTemplateResolverException("Unexpected error resolving policy template " + policyTemplate.getKey().getName(),
                                                e);
    }
  }

}
