/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.factory;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.HttpResourcePointcut;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.model.EmptyPolicySpecification;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicySpecification;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import com.mulesoft.mule.runtime.gw.policies.encryption.EncryptedPolicyException;
import com.mulesoft.mule.runtime.gw.policies.factory.DefaultPolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.serialization.PolicySpecificationBuilder;
import com.mulesoft.mule.runtime.gw.policies.template.PolicyTemplate;
import com.mulesoft.mule.runtime.gw.policies.template.provider.PolicyTemplateProvider;
import com.mulesoft.mule.runtime.gw.policies.template.resolver.PolicyTemplateResolver;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultPolicyFactoryTestCase
extends AbstractMuleTestCase {
    private PolicyFactory policyFactory;
    @Mock
    private PolicyTemplate template;
    private String resolvedTemplate = "someTemplate";

    @Before
    public void setUp() {
        PolicyTemplateResolver templateResolver = (PolicyTemplateResolver)Mockito.mock(PolicyTemplateResolver.class);
        PolicyTemplateProvider templateProvider = (PolicyTemplateProvider)Mockito.mock(PolicyTemplateProvider.class);
        Mockito.when((Object)templateProvider.provide((PolicyTemplateKey)org.mockito.Matchers.any())).thenReturn((Object)this.template);
        Mockito.when((Object)templateResolver.resolve((PolicyTemplate)org.mockito.Matchers.eq((Object)this.template), (Map)org.mockito.Matchers.any())).thenReturn((Object)this.resolvedTemplate);
        Mockito.when((Object)this.template.getPolicySpecification()).thenReturn((Object)new EmptyPolicySpecification());
        this.policyFactory = new DefaultPolicyFactory(templateResolver, templateProvider);
    }

    @Test
    public void createPolicy() {
        PolicyDefinition policyDefinition = (PolicyDefinition)Mockito.mock(PolicyDefinition.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Policy policy = this.policyFactory.createFromPolicyDefinition(policyDefinition);
        Assert.assertThat((Object)policy.getPolicyTemplate(), (Matcher)Matchers.is((Object)this.template));
        Assert.assertThat((Object)policy.getPolicyDefinition(), (Matcher)Matchers.is((Object)policyDefinition));
        Assert.assertThat((Object)policy.getResolvedTemplate(), (Matcher)Matchers.is((Object)this.resolvedTemplate));
    }

    @Test(expected=EncryptedPolicyException.class)
    public void encryptedPolicyWithNoKey() {
        PolicyDefinition policyDefinition = (PolicyDefinition)Mockito.mock(PolicyDefinition.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)policyDefinition.getConfigurationData().isEncrypted()).thenReturn((Object)true);
        this.policyFactory.createFromPolicyDefinition(policyDefinition);
    }

    @Test
    public void createPolicyRemovingIdentityManagement() {
        PolicyConfiguration policyConfiguration = new PolicyConfiguration((Map)ImmutableMap.of((Object)"string", (Object)"value", (Object)"int", (Object)60000, (Object)"identityManagementTokenUrl", (Object)"identityManagementTokenUrlValue", (Object)"identityManagementClientSecret", (Object)"u6gMLNLHDv4QRAqqzRezPqcDoohC0vMTvtKUqy5", (Object)"identityManagementClientId", (Object)"api_platform"));
        PolicyDefinition policyDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, new ApiKey(Long.valueOf(1L)), (List)Lists.newArrayList((Object[])new HttpResourcePointcut[]{new HttpResourcePointcut(".*", "GET")}), 1, policyConfiguration);
        PolicySpecification policySpecification = new PolicySpecificationBuilder().withFile(new File(((Object)((Object)this)).getClass().getResource("/specs/client-id-enforcement.yaml").getFile())).build();
        Mockito.when((Object)this.template.getPolicySpecification()).thenReturn((Object)policySpecification);
        Policy policy = this.policyFactory.createFromPolicyDefinition(policyDefinition);
        Assert.assertThat((Object)policy.getPolicyTemplate(), (Matcher)Matchers.is((Object)this.template));
        Assert.assertThat(policy.getPolicyDefinition().getConfigurationData().getConfiguration().get("identityManagementTokenUrl"), (Matcher)Matchers.nullValue());
        Assert.assertThat(policy.getPolicyDefinition().getConfigurationData().getConfiguration().get("identityManagementClientSecret"), (Matcher)Matchers.nullValue());
        Assert.assertThat(policy.getPolicyDefinition().getConfigurationData().getConfiguration().get("identityManagementClientId"), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)policy.getPolicyDefinition().getName(), (Matcher)Matchers.is((Object)policyDefinition.getName()));
        Assert.assertThat((Object)policy.getPolicyDefinition().getTemplateKey(), (Matcher)Matchers.is((Object)policyDefinition.getTemplateKey()));
        Assert.assertThat((Object)policy.getPolicyDefinition().getHttpResourcePointcuts(), (Matcher)Matchers.is((Object)policyDefinition.getHttpResourcePointcuts()));
        Assert.assertThat((Object)policy.getPolicyDefinition().getApiKeys(), (Matcher)Matchers.is((Object)policyDefinition.getApiKeys()));
        Assert.assertThat((Object)policy.getPolicyDefinition().getOrder(), (Matcher)Matchers.is((Object)policyDefinition.getOrder()));
        Assert.assertThat((Object)policy.getPolicyDefinition().getId(), (Matcher)Matchers.is((Object)policyDefinition.getId()));
        Assert.assertThat((Object)policy.getResolvedTemplate(), (Matcher)Matchers.is((Object)this.resolvedTemplate));
    }

    @Test
    public void createPolicyNotRemovingIdentityManagement() {
        PolicyConfiguration policyConfiguration = new PolicyConfiguration((Map)ImmutableMap.of((Object)"string", (Object)"value", (Object)"int", (Object)60000, (Object)"identityManagementTokenUrl", (Object)"identityManagementTokenUrlValue", (Object)"identityManagementClientSecret", (Object)"u6gMLNLHDv4QRAqqzRezPqcDoohC0vMTvtKUqy5", (Object)"identityManagementClientId", (Object)"api_platform"));
        PolicyDefinition policyDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, new ApiKey(Long.valueOf(1L)), (List)Lists.newArrayList((Object[])new HttpResourcePointcut[]{new HttpResourcePointcut(".*", "GET")}), 1, policyConfiguration);
        PolicySpecification policySpecification = new PolicySpecificationBuilder().withFile(new File(((Object)((Object)this)).getClass().getResource("/specs/openidconnect-access-token-enforcement.yaml").getFile())).build();
        Mockito.when((Object)this.template.getPolicySpecification()).thenReturn((Object)policySpecification);
        Policy policy = this.policyFactory.createFromPolicyDefinition(policyDefinition);
        Assert.assertThat((Object)policy.getPolicyTemplate(), (Matcher)Matchers.is((Object)this.template));
        Assert.assertThat(policy.getPolicyDefinition().getConfigurationData().getConfiguration().get("identityManagementTokenUrl"), (Matcher)Matchers.is((Object)"identityManagementTokenUrlValue"));
        Assert.assertThat(policy.getPolicyDefinition().getConfigurationData().getConfiguration().get("identityManagementClientSecret"), (Matcher)Matchers.is((Object)"u6gMLNLHDv4QRAqqzRezPqcDoohC0vMTvtKUqy5"));
        Assert.assertThat(policy.getPolicyDefinition().getConfigurationData().getConfiguration().get("identityManagementClientId"), (Matcher)Matchers.is((Object)"api_platform"));
        Assert.assertThat((Object)policy.getPolicyDefinition().getName(), (Matcher)Matchers.is((Object)policyDefinition.getName()));
        Assert.assertThat((Object)policy.getPolicyDefinition().getTemplateKey(), (Matcher)Matchers.is((Object)policyDefinition.getTemplateKey()));
        Assert.assertThat((Object)policy.getPolicyDefinition().getHttpResourcePointcuts(), (Matcher)Matchers.is((Object)policyDefinition.getHttpResourcePointcuts()));
        Assert.assertThat((Object)policy.getPolicyDefinition().getApiKeys(), (Matcher)Matchers.is((Object)policyDefinition.getApiKeys()));
        Assert.assertThat((Object)policy.getPolicyDefinition().getOrder(), (Matcher)Matchers.is((Object)policyDefinition.getOrder()));
        Assert.assertThat((Object)policy.getPolicyDefinition().getId(), (Matcher)Matchers.is((Object)policyDefinition.getId()));
        Assert.assertThat((Object)policy.getResolvedTemplate(), (Matcher)Matchers.is((Object)this.resolvedTemplate));
    }
}

