/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.pointcut;

import com.google.common.collect.ImmutableMap;
import com.mulesoft.anypoint.tests.logger.MockLogger;
import com.mulesoft.anypoint.tests.logger.TraceLine;
import com.mulesoft.mule.runtime.gw.api.policy.HttpResourcePointcut;
import com.mulesoft.mule.runtime.gw.policies.pointcut.PointcutTestUtils;
import com.mulesoft.mule.runtime.gw.reflection.VariableOverride;
import java.util.Map;
import javax.xml.namespace.QName;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.policy.api.PolicyPointcutParameters;

public class HttpResourcePointcutTestCase {
    private MockLogger logger;

    @Before
    public void setUp() {
        this.logger = new MockLogger();
    }

    @Test
    public void resourceMatchesListenerParameters() {
        HttpResourcePointcut pointcut = new HttpResourcePointcut("/path", "Get");
        VariableOverride.overrideLogger().in((Object)pointcut).with((Object)this.logger);
        PolicyPointcutParameters parameters = PointcutTestUtils.listenerPointcutParameters("", "/path", "Get", (Map<QName, Object>)ImmutableMap.of());
        boolean matches = pointcut.matches(parameters);
        Assert.assertTrue((boolean)matches);
        Assert.assertThat((Object)this.logger.lines(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(this.logger.lines().get(0), (Matcher)Matchers.is((Object)new TraceLine("Request {{}, {}} matches the following resource pointcut: {}", new Object[]{"/path", "Get", pointcut})));
    }

    @Test
    public void resourceMatchesRequestParameters() {
        HttpResourcePointcut pointcut = new HttpResourcePointcut("/path", "Get");
        VariableOverride.overrideLogger().in((Object)pointcut).with((Object)this.logger);
        PolicyPointcutParameters parameters = PointcutTestUtils.requesterPointcutParameters("", "/path", "Get", (Map<QName, Object>)ImmutableMap.of());
        boolean matches = pointcut.matches(parameters);
        Assert.assertTrue((boolean)matches);
        Assert.assertThat((Object)this.logger.lines(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(this.logger.lines().get(0), (Matcher)Matchers.is((Object)new TraceLine("Request {{}, {}} matches the following resource pointcut: {}", new Object[]{"/path", "Get", pointcut})));
    }

    @Test
    public void resourceDifferentCasingMatches() {
        HttpResourcePointcut pointcut = new HttpResourcePointcut("/PATH", "GET");
        VariableOverride.overrideLogger().in((Object)pointcut).with((Object)this.logger);
        PolicyPointcutParameters parameters = PointcutTestUtils.listenerPointcutParameters("", "/path", "Get", (Map<QName, Object>)ImmutableMap.of());
        boolean matches = pointcut.matches(parameters);
        Assert.assertTrue((boolean)matches);
        Assert.assertThat((Object)this.logger.lines(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(this.logger.lines().get(0), (Matcher)Matchers.is((Object)new TraceLine("Request {{}, {}} matches the following resource pointcut: {}", new Object[]{"/path", "Get", pointcut})));
    }

    @Test
    public void regexPatternsMatches() {
        HttpResourcePointcut pointcut = new HttpResourcePointcut(".*", ".*");
        VariableOverride.overrideLogger().in((Object)pointcut).with((Object)this.logger);
        PolicyPointcutParameters parameters = PointcutTestUtils.listenerPointcutParameters("", "/path", "Get", (Map<QName, Object>)ImmutableMap.of());
        boolean matches = pointcut.matches(parameters);
        Assert.assertTrue((boolean)matches);
        Assert.assertThat((Object)this.logger.lines(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(this.logger.lines().get(0), (Matcher)Matchers.is((Object)new TraceLine("Request {{}, {}} matches the following resource pointcut: {}", new Object[]{"/path", "Get", pointcut})));
    }

    @Test
    public void pathMismatches() {
        HttpResourcePointcut pointcut = new HttpResourcePointcut("/path", ".*");
        VariableOverride.overrideLogger().in((Object)pointcut).with((Object)this.logger);
        PolicyPointcutParameters parameters = PointcutTestUtils.listenerPointcutParameters("", "/pathh", "POST", (Map<QName, Object>)ImmutableMap.of());
        boolean matches = pointcut.matches(parameters);
        Assert.assertFalse((boolean)matches);
        Assert.assertThat((Object)this.logger.lines(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(this.logger.lines().get(0), (Matcher)Matchers.is((Object)new TraceLine("Request {{}, {}} does not match the following resource pointcut: {}", new Object[]{"/pathh", "POST", pointcut})));
    }

    @Test
    public void methodMismatches() {
        HttpResourcePointcut pointcut = new HttpResourcePointcut(".*", "GET");
        VariableOverride.overrideLogger().in((Object)pointcut).with((Object)this.logger);
        PolicyPointcutParameters parameters = PointcutTestUtils.listenerPointcutParameters("", "/path", "POST", (Map<QName, Object>)ImmutableMap.of());
        boolean matches = pointcut.matches(parameters);
        Assert.assertFalse((boolean)matches);
        Assert.assertThat((Object)this.logger.lines(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(this.logger.lines().get(0), (Matcher)Matchers.is((Object)new TraceLine("Request {{}, {}} does not match the following resource pointcut: {}", new Object[]{"/path", "POST", pointcut})));
    }

    @Test
    public void invalidParametersType() {
        HttpResourcePointcut pointcut = new HttpResourcePointcut(".*", "GET");
        VariableOverride.overrideLogger().in((Object)pointcut).with((Object)this.logger);
        PolicyPointcutParameters parameters = PointcutTestUtils.nonHttpPointcutParameters("");
        boolean matches = pointcut.matches(parameters);
        Assert.assertFalse((boolean)matches);
        Assert.assertThat((Object)this.logger.lines(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(this.logger.lines().get(0), (Matcher)Matchers.is((Object)new TraceLine("Invalid parameters type found. {}", new Object[]{"org.mule.runtime.policy.api.PolicyPointcutParameters cannot be cast to org.mule.runtime.http.policy.api.HttpPolicyPointcutParameters"})));
    }
}

