/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.service;

import com.google.common.collect.Lists;
import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.deployment.DefaultTransactionalPolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.deployment.PolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.deployment.TransactionalPolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.service.DefaultPolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.policies.service.DeploymentStatusTestFactory;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStore;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class TransactionalPolicyDeployerTestCase
extends AbstractMuleTestCase {
    private static final PolicyDefinition definition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 1, Collections.emptyMap());
    private static final PolicyDefinition differentDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 1, Collections.singletonMap("param", "value"));
    private static final String definitionName = definition.getName();
    private Api api;
    private PolicyStore policyStore;
    private PolicyDeploymentTracker policyDeploymentTracker;
    private PolicyDeployer policyDeployer;
    private TransactionalPolicyDeployer transactionalDeployer;

    @Before
    public void setUp() {
        this.api = this.mockAPi();
        this.policyDeploymentTracker = new DefaultPolicyDeploymentTracker();
        this.policyStore = (PolicyStore)Mockito.mock(PolicyStore.class);
        this.policyDeployer = (PolicyDeployer)Mockito.mock(PolicyDeployer.class);
        this.transactionalDeployer = new DefaultTransactionalPolicyDeployer(this.policyDeploymentTracker, this.policyStore, this.policyDeployer);
    }

    @Test
    public void reorderSuccess() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, DeploymentStatusTestFactory.applied(differentDefinition));
        Mockito.when((Object)this.policyDeployer.updateOrder(definition, this.api)).thenReturn((Object)DeploymentStatusTestFactory.appliedDefinition(definition));
        this.transactionalDeployer.updateOrder(differentDefinition, definition, this.api);
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat(this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0), (Matcher)Is.is((Object)DeploymentStatusTestFactory.applied(definition)));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.policyDeployer, this.policyStore});
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).updateOrder(definition, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).cleanDeploymentFailure(definition, PolicyTestValuesConstants.API_KEY);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void hotReorderFails() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, DeploymentStatusTestFactory.applied(differentDefinition));
        Mockito.when((Object)this.policyDeployer.updateOrder(definition, this.api)).thenReturn((Object)DeploymentStatusTestFactory.deploymentFailedDefinition(definition));
        Mockito.when((Object)this.policyDeployer.undeploy(definitionName, this.api)).thenReturn((Object)true);
        Mockito.when((Object)this.policyDeployer.deploy(definition, this.api)).thenReturn((Object)DeploymentStatusTestFactory.appliedDefinition(definition));
        this.transactionalDeployer.updateOrder(differentDefinition, definition, this.api);
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat(this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0), (Matcher)Is.is((Object)DeploymentStatusTestFactory.applied(definition)));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.policyDeployer, this.policyStore});
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).updateOrder(definition, this.api);
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).undeploy(definitionName, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).remove(definitionName);
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).deploy(definition, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).cleanDeploymentFailure(definition, PolicyTestValuesConstants.API_KEY);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void hotReorderFailsUpdateFails() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, DeploymentStatusTestFactory.applied(differentDefinition));
        Mockito.when((Object)this.policyDeployer.updateOrder(definition, this.api)).thenReturn((Object)DeploymentStatusTestFactory.deploymentFailedDefinition(definition));
        Mockito.when((Object)this.policyDeployer.undeploy(definitionName, this.api)).thenReturn((Object)true);
        Mockito.when((Object)this.policyDeployer.deploy(definition, this.api)).thenReturn((Object)DeploymentStatusTestFactory.deploymentFailedDefinition(definition));
        Mockito.when((Object)this.policyDeployer.deploy(differentDefinition, this.api)).thenReturn((Object)DeploymentStatusTestFactory.appliedDefinition(differentDefinition));
        this.transactionalDeployer.updateOrder(differentDefinition, definition, this.api);
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat(this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0), (Matcher)Is.is((Object)DeploymentStatusTestFactory.deploymentFailed(differentDefinition, definition)));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.policyDeployer, this.policyStore});
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).updateOrder(definition, this.api);
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).undeploy(definitionName, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).remove(definitionName);
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).deploy(definition, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).remove(definitionName);
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).deploy(differentDefinition, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).store(differentDefinition);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).storeDeploymentFailure(definition, PolicyTestValuesConstants.API_KEY, null);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void hotReorderFailsUpdateFailsRevertFails() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, DeploymentStatusTestFactory.applied(differentDefinition));
        Mockito.when((Object)this.policyDeployer.updateOrder(definition, this.api)).thenReturn((Object)DeploymentStatusTestFactory.deploymentFailedDefinition(definition));
        Mockito.when((Object)this.policyDeployer.undeploy(definitionName, this.api)).thenReturn((Object)true);
        Mockito.when((Object)this.policyDeployer.deploy(definition, this.api)).thenReturn((Object)DeploymentStatusTestFactory.deploymentFailedDefinition(definition));
        Mockito.when((Object)this.policyDeployer.deploy(differentDefinition, this.api)).thenReturn((Object)DeploymentStatusTestFactory.deploymentFailedDefinition(differentDefinition));
        this.transactionalDeployer.updateOrder(differentDefinition, definition, this.api);
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat(this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0), (Matcher)Is.is((Object)DeploymentStatusTestFactory.deploymentFailed(definition)));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.policyDeployer, this.policyStore});
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).updateOrder(definition, this.api);
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).undeploy(definitionName, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).remove(definitionName);
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).deploy(definition, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).remove(definitionName);
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).deploy(differentDefinition, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).store(definition);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).storeDeploymentFailure(definition, PolicyTestValuesConstants.API_KEY, null);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void updateSuccess() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, DeploymentStatusTestFactory.applied(differentDefinition));
        Mockito.when((Object)this.policyDeployer.undeploy(definitionName, this.api)).thenReturn((Object)true);
        Mockito.when((Object)this.policyDeployer.deploy(definition, this.api)).thenReturn((Object)DeploymentStatusTestFactory.appliedDefinition(definition));
        this.transactionalDeployer.update(differentDefinition, definition, this.api);
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat(this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0), (Matcher)Is.is((Object)DeploymentStatusTestFactory.applied(definition)));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.policyDeployer, this.policyStore});
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).undeploy(definitionName, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).remove(definitionName);
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).deploy(definition, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).cleanDeploymentFailure(definition, PolicyTestValuesConstants.API_KEY);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void updateFails() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, DeploymentStatusTestFactory.applied(differentDefinition));
        Mockito.when((Object)this.policyDeployer.undeploy(definitionName, this.api)).thenReturn((Object)true);
        Mockito.when((Object)this.policyDeployer.deploy(definition, this.api)).thenReturn((Object)DeploymentStatusTestFactory.deploymentFailedDefinition(definition));
        Mockito.when((Object)this.policyDeployer.deploy(differentDefinition, this.api)).thenReturn((Object)DeploymentStatusTestFactory.appliedDefinition(differentDefinition));
        this.transactionalDeployer.update(differentDefinition, definition, this.api);
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat(this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0), (Matcher)Is.is((Object)DeploymentStatusTestFactory.deploymentFailed(differentDefinition, definition)));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.policyDeployer, this.policyStore});
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).undeploy(definitionName, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).remove(definitionName);
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).deploy(definition, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).remove(definitionName);
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).deploy(differentDefinition, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).store(differentDefinition);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).storeDeploymentFailure(definition, PolicyTestValuesConstants.API_KEY, null);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void updateFailsRevertFails() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, DeploymentStatusTestFactory.applied(differentDefinition));
        Mockito.when((Object)this.policyDeployer.undeploy(definitionName, this.api)).thenReturn((Object)true);
        Mockito.when((Object)this.policyDeployer.deploy(definition, this.api)).thenReturn((Object)DeploymentStatusTestFactory.deploymentFailedDefinition(definition));
        Mockito.when((Object)this.policyDeployer.deploy(differentDefinition, this.api)).thenReturn((Object)DeploymentStatusTestFactory.deploymentFailedDefinition(differentDefinition));
        this.transactionalDeployer.update(differentDefinition, definition, this.api);
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat(this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0), (Matcher)Is.is((Object)DeploymentStatusTestFactory.deploymentFailed(definition)));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.policyDeployer, this.policyStore});
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).undeploy(definitionName, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).remove(definitionName);
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).deploy(definition, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).remove(definitionName);
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).deploy(differentDefinition, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).store(definition);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).storeDeploymentFailure(definition, PolicyTestValuesConstants.API_KEY, null);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void updateWhenFailedDeploy() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, DeploymentStatusTestFactory.deploymentFailed(differentDefinition));
        Mockito.when((Object)this.policyDeployer.undeploy(definitionName, this.api)).thenReturn((Object)true);
        Mockito.when((Object)this.policyDeployer.deploy(definition, this.api)).thenReturn((Object)DeploymentStatusTestFactory.appliedDefinition(definition));
        this.transactionalDeployer.deploy(definition, this.api);
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat(this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0), (Matcher)Is.is((Object)DeploymentStatusTestFactory.applied(definition)));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.policyDeployer, this.policyStore});
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).deploy(definition, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).cleanDeploymentFailure(definition, PolicyTestValuesConstants.API_KEY);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void updateFailsWhenFailedDeploy() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, DeploymentStatusTestFactory.deploymentFailed(differentDefinition));
        Mockito.when((Object)this.policyDeployer.undeploy(definitionName, this.api)).thenReturn((Object)true);
        Mockito.when((Object)this.policyDeployer.deploy(definition, this.api)).thenReturn((Object)DeploymentStatusTestFactory.deploymentFailedDefinition(definition));
        this.transactionalDeployer.deploy(definition, this.api);
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat(this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0), (Matcher)Is.is((Object)DeploymentStatusTestFactory.deploymentFailed(definition)));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.policyDeployer, this.policyStore});
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).deploy(definition, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).store(definition);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).storeDeploymentFailure(definition, PolicyTestValuesConstants.API_KEY, null);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void revertPolicy() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, DeploymentStatusTestFactory.deploymentFailed(definition, differentDefinition));
        this.transactionalDeployer.revertPolicy(definition, this.api);
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat(this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0), (Matcher)Is.is((Object)DeploymentStatusTestFactory.applied(definition)));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.policyDeployer, this.policyStore});
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).cleanDeploymentFailure(definition, PolicyTestValuesConstants.API_KEY);
        inOrder.verifyNoMoreInteractions();
    }

    private Api mockAPi() {
        Api api = (Api)Mockito.mock(Api.class);
        ApiImplementation impl = (ApiImplementation)Mockito.mock(ApiImplementation.class);
        Mockito.when((Object)api.getKey()).thenReturn((Object)PolicyTestValuesConstants.API_KEY);
        Mockito.when((Object)api.getImplementation()).thenReturn((Object)impl);
        Mockito.when((Object)impl.getApiKey()).thenReturn((Object)PolicyTestValuesConstants.API_KEY);
        Mockito.when((Object)impl.getArtifactName()).thenReturn((Object)"MyArtifact");
        return api;
    }
}

