/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.service.detection;

import com.google.common.collect.Lists;
import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.mule.runtime.gw.api.policy.HttpResourcePointcut;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.service.DeploymentStatusTestFactory;
import com.mulesoft.mule.runtime.gw.policies.service.detection.PolicyChangeInspector;
import com.mulesoft.mule.runtime.gw.policies.service.detection.change.ChangeType;
import com.mulesoft.mule.runtime.gw.policies.service.detection.change.PolicyAdded;
import com.mulesoft.mule.runtime.gw.policies.service.detection.change.PolicyReorder;
import com.mulesoft.mule.runtime.gw.policies.service.detection.change.PolicyRevert;
import com.mulesoft.mule.runtime.gw.policies.service.detection.change.PolicyUnmodified;
import com.mulesoft.mule.runtime.gw.policies.service.detection.change.PolicyUpdate;
import com.mulesoft.mule.runtime.gw.policies.service.detection.change.RecoverableChangeType;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Test;

public class PolicyChangeInspectorTestCase {
    private static final PolicyDefinition definition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 1, Collections.emptyMap());
    private static final PolicyDefinition differentDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 1, Collections.singletonMap("param", "value"));
    PolicyChangeInspector inspector = new PolicyChangeInspector();

    @Test
    public void noChangesWhenSuccessfullyApplied() {
        ChangeType change = this.inspector.detectChange(DeploymentStatusTestFactory.applied(definition), definition);
        MatcherAssert.assertThat((Object)change, (Matcher)IsInstanceOf.instanceOf(PolicyUnmodified.class));
        MatcherAssert.assertThat((Object)change.getDefinition(), (Matcher)Is.is((Object)definition));
    }

    @Test
    public void noChangesWhenDeploymentFailed() {
        ChangeType change = this.inspector.detectChange(DeploymentStatusTestFactory.deploymentFailed(definition), definition);
        MatcherAssert.assertThat((Object)change, (Matcher)IsInstanceOf.instanceOf(PolicyUnmodified.class));
        MatcherAssert.assertThat((Object)change.getDefinition(), (Matcher)Is.is((Object)definition));
    }

    @Test
    public void noChangesWhenDeploymentFailedWithPreviousSuccess() {
        ChangeType change = this.inspector.detectChange(DeploymentStatusTestFactory.deploymentFailed(definition, differentDefinition), differentDefinition);
        MatcherAssert.assertThat((Object)change, (Matcher)IsInstanceOf.instanceOf(PolicyUnmodified.class));
        MatcherAssert.assertThat((Object)change.getDefinition(), (Matcher)Is.is((Object)differentDefinition));
    }

    @Test
    public void reorder() {
        PolicyDefinition reorderedDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 2, Collections.emptyMap());
        ChangeType change = this.inspector.detectChange(DeploymentStatusTestFactory.applied(definition), reorderedDefinition);
        MatcherAssert.assertThat((Object)change, (Matcher)IsInstanceOf.instanceOf(PolicyReorder.class));
        MatcherAssert.assertThat((Object)change.getDefinition(), (Matcher)Is.is((Object)reorderedDefinition));
        MatcherAssert.assertThat((Object)((RecoverableChangeType)change).getAppliedDefinition(), (Matcher)Is.is((Object)definition));
    }

    @Test
    public void reorderOfApplied() {
        PolicyDefinition reorderedDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 2, Collections.emptyMap());
        ChangeType change = this.inspector.detectChange(DeploymentStatusTestFactory.deploymentFailed(definition, differentDefinition), reorderedDefinition);
        MatcherAssert.assertThat((Object)change, (Matcher)IsInstanceOf.instanceOf(PolicyReorder.class));
        MatcherAssert.assertThat((Object)change.getDefinition(), (Matcher)Is.is((Object)reorderedDefinition));
        MatcherAssert.assertThat((Object)((RecoverableChangeType)change).getAppliedDefinition(), (Matcher)Is.is((Object)definition));
    }

    @Test
    public void updateConfig() {
        ChangeType change = this.inspector.detectChange(DeploymentStatusTestFactory.applied(definition), differentDefinition);
        MatcherAssert.assertThat((Object)change, (Matcher)IsInstanceOf.instanceOf(PolicyUpdate.class));
        MatcherAssert.assertThat((Object)change.getDefinition(), (Matcher)Is.is((Object)differentDefinition));
        MatcherAssert.assertThat((Object)((RecoverableChangeType)change).getAppliedDefinition(), (Matcher)Is.is((Object)definition));
    }

    @Test
    public void updateOrderPlusAnotherChange() {
        PolicyDefinition newDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 2, Collections.singletonMap("param", "value"));
        ChangeType change = this.inspector.detectChange(DeploymentStatusTestFactory.applied(definition), newDefinition);
        MatcherAssert.assertThat((Object)change, (Matcher)IsInstanceOf.instanceOf(PolicyUpdate.class));
        MatcherAssert.assertThat((Object)change.getDefinition(), (Matcher)Is.is((Object)newDefinition));
        MatcherAssert.assertThat((Object)((RecoverableChangeType)change).getAppliedDefinition(), (Matcher)Is.is((Object)definition));
    }

    @Test
    public void updateTemplateKey() {
        PolicyDefinition newDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY_2, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 1, Collections.emptyMap());
        ChangeType change = this.inspector.detectChange(DeploymentStatusTestFactory.applied(definition), newDefinition);
        MatcherAssert.assertThat((Object)change, (Matcher)IsInstanceOf.instanceOf(PolicyUpdate.class));
        MatcherAssert.assertThat((Object)change.getDefinition(), (Matcher)Is.is((Object)newDefinition));
        MatcherAssert.assertThat((Object)((RecoverableChangeType)change).getAppliedDefinition(), (Matcher)Is.is((Object)definition));
    }

    @Test
    public void updatePointcuts() {
        PolicyDefinition newDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, Collections.singletonList(new HttpResourcePointcut("GET", "/foo.*")), 1, Collections.emptyMap());
        ChangeType change = this.inspector.detectChange(DeploymentStatusTestFactory.applied(definition), newDefinition);
        MatcherAssert.assertThat((Object)change, (Matcher)IsInstanceOf.instanceOf(PolicyUpdate.class));
        MatcherAssert.assertThat((Object)change.getDefinition(), (Matcher)Is.is((Object)newDefinition));
        MatcherAssert.assertThat((Object)((RecoverableChangeType)change).getAppliedDefinition(), (Matcher)Is.is((Object)definition));
    }

    @Test
    public void updateDeploymentFailedApplied() {
        PolicyDefinition anotherDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 1, Collections.singletonMap("param", "value2"));
        ChangeType change = this.inspector.detectChange(DeploymentStatusTestFactory.deploymentFailed(definition, anotherDefinition), differentDefinition);
        MatcherAssert.assertThat((Object)change, (Matcher)IsInstanceOf.instanceOf(PolicyUpdate.class));
        MatcherAssert.assertThat((Object)change.getDefinition(), (Matcher)Is.is((Object)differentDefinition));
        MatcherAssert.assertThat((Object)((RecoverableChangeType)change).getAppliedDefinition(), (Matcher)Is.is((Object)definition));
    }

    @Test
    public void updateDownloadFailedRecoverable() {
        ChangeType change = this.inspector.detectChange(DeploymentStatusTestFactory.downloadFailed(definition, differentDefinition), differentDefinition);
        MatcherAssert.assertThat((Object)change, (Matcher)IsInstanceOf.instanceOf(PolicyUpdate.class));
        MatcherAssert.assertThat((Object)change.getDefinition(), (Matcher)Is.is((Object)differentDefinition));
        MatcherAssert.assertThat((Object)((RecoverableChangeType)change).getAppliedDefinition(), (Matcher)Is.is((Object)definition));
    }

    @Test
    public void updateDownloadFailed() {
        ChangeType change = this.inspector.detectChange(DeploymentStatusTestFactory.downloadFailed(definition), definition);
        MatcherAssert.assertThat((Object)change, (Matcher)IsInstanceOf.instanceOf(PolicyAdded.class));
        MatcherAssert.assertThat((Object)change.getDefinition(), (Matcher)Is.is((Object)definition));
    }

    @Test
    public void updateDeploymentFailed() {
        ChangeType change = this.inspector.detectChange(DeploymentStatusTestFactory.deploymentFailed(definition), differentDefinition);
        MatcherAssert.assertThat((Object)change, (Matcher)IsInstanceOf.instanceOf(PolicyAdded.class));
        MatcherAssert.assertThat((Object)change.getDefinition(), (Matcher)Is.is((Object)differentDefinition));
    }

    @Test
    public void updateOrderDeploymentFailed() {
        PolicyDefinition reorderedDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 2, Collections.emptyMap());
        ChangeType change = this.inspector.detectChange(DeploymentStatusTestFactory.deploymentFailed(definition), reorderedDefinition);
        MatcherAssert.assertThat((Object)change, (Matcher)IsInstanceOf.instanceOf(PolicyAdded.class));
        MatcherAssert.assertThat((Object)change.getDefinition(), (Matcher)Is.is((Object)reorderedDefinition));
    }

    @Test
    public void revertDeploymentFailed() {
        ChangeType change = this.inspector.detectChange(DeploymentStatusTestFactory.deploymentFailed(definition, differentDefinition), definition);
        MatcherAssert.assertThat((Object)change, (Matcher)IsInstanceOf.instanceOf(PolicyRevert.class));
        MatcherAssert.assertThat((Object)change.getDefinition(), (Matcher)Is.is((Object)definition));
    }

    @Test
    public void revertDownloadFailed() {
        ChangeType change = this.inspector.detectChange(DeploymentStatusTestFactory.downloadFailed(definition, differentDefinition), definition);
        MatcherAssert.assertThat((Object)change, (Matcher)IsInstanceOf.instanceOf(PolicyRevert.class));
        MatcherAssert.assertThat((Object)change.getDefinition(), (Matcher)Is.is((Object)definition));
    }
}

