/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.service.detection;

import com.google.common.collect.Lists;
import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.service.DeploymentStatusTestFactory;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.detection.PolicyChangeProcessor;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class PolicyChangeProcessorTestCase
extends AbstractMuleTestCase {
    private static final PolicyDefinition definition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 1, Collections.emptyMap());
    private static final PolicyDefinition updatedDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 1, Collections.singletonMap("foo", "bar"));
    private PolicyDeploymentService deploymentService;
    private PolicyChangeProcessor changeProcessor;

    @Before
    public void setUp() {
        this.deploymentService = (PolicyDeploymentService)Mockito.mock(PolicyDeploymentService.class);
        this.changeProcessor = new PolicyChangeProcessor(this.deploymentService);
    }

    @Test
    public void newPolicy() {
        this.changeProcessor.process(Collections.emptyList(), Collections.singletonList(definition));
        ((PolicyDeploymentService)Mockito.verify((Object)this.deploymentService)).newPolicy(definition);
    }

    @Test
    public void reorder() {
        PolicyDefinition reordered = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 2, Collections.emptyMap());
        this.changeProcessor.process(Collections.singletonList(DeploymentStatusTestFactory.applied(definition)), Collections.singletonList(reordered));
        ((PolicyDeploymentService)Mockito.verify((Object)this.deploymentService)).reorderPolicy(definition, reordered);
    }

    @Test
    public void update() {
        this.changeProcessor.process(Collections.singletonList(DeploymentStatusTestFactory.applied(definition)), Collections.singletonList(updatedDefinition));
        ((PolicyDeploymentService)Mockito.verify((Object)this.deploymentService)).updatePolicy(definition, updatedDefinition);
    }

    @Test
    public void revertPolicy() {
        this.changeProcessor.process(Collections.singletonList(DeploymentStatusTestFactory.deploymentFailed(definition, updatedDefinition)), Collections.singletonList(definition));
        ((PolicyDeploymentService)Mockito.verify((Object)this.deploymentService)).revertPolicy(definition);
    }

    @Test
    public void removePolicy() {
        this.changeProcessor.process(Collections.singletonList(DeploymentStatusTestFactory.applied(definition)), Collections.emptyList());
        ((PolicyDeploymentService)Mockito.verify((Object)this.deploymentService)).removePolicy(definition);
    }
}

